/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.observedEarthquake;

import java.io.Serializable;
import java.util.GregorianCalendar;
import org.opensha.commons.data.Location;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.PointSurface;

public class ObsEqkRupture
extends EqkRupture
implements Serializable {
    private String eventId;
    private String dataSource;
    private char eventVersion;
    private GregorianCalendar originTime;
    private double hypoLocHorzErr;
    private double hypoLocVertErr;
    private double magError;
    private String magType;

    public ObsEqkRupture() {
    }

    public ObsEqkRupture(String eventId, String dataSource, char eventVersion, GregorianCalendar originTime, double hypoLocHorzErr, double hypoLocVertErr, double magError, String magType, Location hypoLoc, double mag) {
        super(mag, 0.0, null, hypoLoc);
        PointSurface surface = new PointSurface(hypoLoc);
        this.setRuptureSurface(surface);
        this.setObsEqkRup(eventId, dataSource, eventVersion, originTime, hypoLocHorzErr, hypoLocVertErr, magError, magType);
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getEventId() {
        return this.eventId;
    }

    public char getEventVersion() {
        return this.eventVersion;
    }

    public double getHypoLocHorzErr() {
        return this.hypoLocHorzErr;
    }

    public double getHypoLocVertErr() {
        return this.hypoLocVertErr;
    }

    public GregorianCalendar getOriginTime() {
        return this.originTime;
    }

    public double getMagError() {
        return this.magError;
    }

    public String getMagType() {
        return this.magType;
    }

    public void setObsEqkRup(String eventId, String dataSource, char eventVersion, GregorianCalendar originTime, double hypoLocHorzErr, double hypoLocVertErr, double magError, String magType) {
        this.eventId = eventId;
        this.dataSource = dataSource;
        this.eventVersion = eventVersion;
        this.originTime = originTime;
        this.hypoLocHorzErr = hypoLocHorzErr;
        this.hypoLocVertErr = hypoLocVertErr;
        this.magError = magError;
        this.magType = magType;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setEventVersion(char eventVersion) {
        this.eventVersion = eventVersion;
    }

    public void setHypoLocHorzErr(double hypoLocHorzErr) {
        this.hypoLocHorzErr = hypoLocHorzErr;
    }

    public void setHypoLocVertErr(double hypoLocVertErr) {
        this.hypoLocVertErr = hypoLocVertErr;
    }

    public void setOriginTime(GregorianCalendar originTime) {
        this.originTime = originTime;
    }

    public void setMagError(double magError) {
        this.magError = magError;
    }

    public void setMagType(String magType) {
        this.magType = magType;
    }

    public boolean equalsObsEqkRupEvent(ObsEqkRupture obsRupEvent) {
        boolean eventsEqual = true;
        if (this.eventId != obsRupEvent.getEventId() || this.eventVersion != obsRupEvent.getEventVersion() || this.magType != obsRupEvent.getMagType() || this.magError != obsRupEvent.getMagError() || this.hypoLocHorzErr != obsRupEvent.getHypoLocHorzErr() || this.hypoLocVertErr != obsRupEvent.getHypoLocVertErr() || this.getMag() != obsRupEvent.getMag()) {
            return false;
        }
        return eventsEqual;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObsEqkRupture) {
            return this.equalsObsEqkRupEvent((ObsEqkRupture)obj);
        }
        return false;
    }

    public String getInfo() {
        String obsEqkInfo = super.getInfo();
        obsEqkInfo = obsEqkInfo + "EventId =" + this.eventId + "\n";
        obsEqkInfo = obsEqkInfo + "DataSource =" + this.dataSource + "\n";
        obsEqkInfo = obsEqkInfo + "EventVersion =" + this.eventVersion + "\n";
        obsEqkInfo = obsEqkInfo + "OriginTime =" + this.originTime.toString() + "\n";
        obsEqkInfo = obsEqkInfo + "HypoLocHorzErr =" + this.hypoLocHorzErr + "\n";
        obsEqkInfo = obsEqkInfo + "HypoLocVertErr =" + this.hypoLocVertErr + "\n";
        obsEqkInfo = obsEqkInfo + "MagError =" + this.magError + "\n";
        obsEqkInfo = obsEqkInfo + "MagType =" + this.magType + "\n";
        return obsEqkInfo;
    }

    public Object clone() {
        ObsEqkRupture eqkEventClone = new ObsEqkRupture();
        eqkEventClone.setEventId(this.eventId);
        eqkEventClone.setMag(this.mag);
        eqkEventClone.setRuptureSurface(this.getRuptureSurface());
        eqkEventClone.setHypocenterLocation(this.hypocenterLocation);
        eqkEventClone.setDataSource(this.dataSource);
        eqkEventClone.setEventVersion(this.eventVersion);
        eqkEventClone.setOriginTime(this.originTime);
        eqkEventClone.setHypoLocHorzErr(this.hypoLocHorzErr);
        eqkEventClone.setHypoLocVertErr(this.hypoLocVertErr);
        eqkEventClone.setMagError(this.magError);
        eqkEventClone.setMagType(this.magType);
        eqkEventClone.setAveRake(this.aveRake);
        return eqkEventClone;
    }
}

