/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.Site;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class FaultRuptureSource
extends ProbEqkSource {
    private static String C = new String("FaultRuptureSource");
    private boolean D = false;
    protected String NAME = "Fault Rupture Source";
    protected double duration;
    private ArrayList ruptureList;
    private ArrayList faultCornerLocations = new ArrayList();

    public FaultRuptureSource(double magnitude, EvenlyGriddedSurface ruptureSurface, double rake, double probability) {
        this.isPoissonian = false;
        if (this.D) {
            System.out.println("mag: " + magnitude);
            System.out.println("surface rows, cols: " + ruptureSurface.getNumCols() + ", " + ruptureSurface.getNumRows());
            System.out.println("rake: " + rake);
            System.out.println("probability: " + probability);
        }
        this.makeFaultCornerLocs(ruptureSurface);
        this.ruptureList = new ArrayList();
        this.probEqkRupture = new ProbEqkRupture();
        this.probEqkRupture.setAveRake(rake);
        this.probEqkRupture.setRuptureSurface(ruptureSurface);
        this.probEqkRupture.setMag(magnitude);
        this.probEqkRupture.setProbability(probability);
        this.ruptureList.add(this.probEqkRupture);
    }

    public EvenlyGriddedSurfaceAPI getSourceSurface() {
        return ((ProbEqkRupture)this.ruptureList.get(0)).getRuptureSurface();
    }

    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        ListIterator it = ((EvenlyGriddedSurface)this.getSourceSurface()).getAllByRowsIterator();
        while (it.hasNext()) {
            locList.addLocation((Location)it.next());
        }
        return locList;
    }

    public FaultRuptureSource(IncrementalMagFreqDist magDist, EvenlyGriddedSurface ruptureSurface, double rake, double duration) {
        this.isPoissonian = true;
        this.duration = duration;
        if (this.D) {
            System.out.println("surface rows, cols: " + ruptureSurface.getNumCols() + ", " + ruptureSurface.getNumRows());
            System.out.println("rake: " + rake);
            System.out.println("duration: " + duration);
        }
        this.makeFaultCornerLocs(ruptureSurface);
        this.ruptureList = new ArrayList();
        for (int i = 0; i < magDist.getNum(); ++i) {
            double mag = magDist.getX(i);
            if (!(magDist.getY(i) > 0.0)) continue;
            double prob = 1.0 - Math.exp(-duration * magDist.getY(i));
            this.probEqkRupture = new ProbEqkRupture();
            this.probEqkRupture.setAveRake(rake);
            this.probEqkRupture.setRuptureSurface(ruptureSurface);
            this.probEqkRupture.setMag(mag);
            this.probEqkRupture.setProbability(prob);
            this.ruptureList.add(this.probEqkRupture);
        }
    }

    public FaultRuptureSource(double prob, IncrementalMagFreqDist magDist, EvenlyGriddedSurface ruptureSurface, double rake) {
        int i;
        this.isPoissonian = false;
        this.makeFaultCornerLocs(ruptureSurface);
        this.ruptureList = new ArrayList();
        double totRate = 0.0;
        for (i = 0; i < magDist.getNum(); ++i) {
            totRate += magDist.getY(i);
        }
        for (i = 0; i < magDist.getNum(); ++i) {
            double d;
            double mag = magDist.getX(i);
            double qkRate = magDist.getY(i);
            if (!(d > 0.0)) continue;
            double qkProb = qkRate * prob / totRate;
            this.probEqkRupture = new ProbEqkRupture();
            this.probEqkRupture.setAveRake(rake);
            this.probEqkRupture.setRuptureSurface(ruptureSurface);
            this.probEqkRupture.setMag(mag);
            this.probEqkRupture.setProbability(qkProb);
            this.ruptureList.add(this.probEqkRupture);
        }
        if (this.D) {
            double totProb = 0.0;
            for (int i2 = 0; i2 < this.ruptureList.size(); ++i2) {
                totProb += this.getRupture(i2).getProbability();
            }
            System.out.println("input prob=" + prob + ", final tot prob=" + totProb + ", ratio=" + prob / totProb);
        }
    }

    public void setDuration(double newDuration) {
        if (!this.isPoissonian) {
            throw new RuntimeException(C + " Error - the setDuration method can only be used for the Poisson case");
        }
        for (int i = 0; i < this.ruptureList.size(); ++i) {
            ProbEqkRupture eqkRup = (ProbEqkRupture)this.ruptureList.get(i);
            double oldProb = eqkRup.getProbability();
            double newProb = 1.0 - Math.pow(1.0 - oldProb, newDuration / this.duration);
            eqkRup.setProbability(newProb);
        }
        this.duration = newDuration;
    }

    public int getNumRuptures() {
        return this.ruptureList.size();
    }

    public ProbEqkRupture getRupture(int nthRupture) {
        return (ProbEqkRupture)this.ruptureList.get(nthRupture);
    }

    public double getMinDistance(Site site) {
        double min = Double.MAX_VALUE;
        Iterator it = this.faultCornerLocations.iterator();
        while (it.hasNext()) {
            double tempMin = RelativeLocation.getHorzDistance(site.getLocation(), (Location)it.next());
            if (!(tempMin < min)) continue;
            min = tempMin;
        }
        return min;
    }

    private void makeFaultCornerLocs(EvenlyGriddedSurface faultSurface) {
        int nRows = faultSurface.getNumRows();
        int nCols = faultSurface.getNumCols();
        this.faultCornerLocations.add(faultSurface.get(0, 0));
        this.faultCornerLocations.add(faultSurface.get(0, nCols / 2));
        this.faultCornerLocations.add(faultSurface.get(0, nCols - 1));
        this.faultCornerLocations.add(faultSurface.get(nRows - 1, 0));
        this.faultCornerLocations.add(faultSurface.get(nRows - 1, nCols / 2));
        this.faultCornerLocations.add(faultSurface.get(nRows - 1, nCols - 1));
    }

    public void setName(String name) {
        this.NAME = name;
    }

    public String getName() {
        return this.NAME;
    }
}

