/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.Frankel02;

import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.calc.magScalingRelations.MagAreaRelationship;
import org.opensha.commons.data.Direction;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.Site;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class Frankel02_TypeB_EqkSource
extends ProbEqkSource {
    private static String C = "Frankel02_GR_EqkSource";
    private boolean D = false;
    private double rake;
    protected double duration;
    private static final double RUPTURE_WIDTH = 100.0;
    private double rupOffset;
    private int totNumRups;
    private EvenlyGriddedSurface surface;
    private ArrayList mags;
    private ArrayList rates;
    private MagAreaRelationship magAreaRel;

    public Frankel02_TypeB_EqkSource() {
    }

    public Frankel02_TypeB_EqkSource(IncrementalMagFreqDist magFreqDist, EvenlyGriddedSurface surface, double rupOffset, double rake, double duration, String sourceName) {
        this.magAreaRel = null;
        this.updateAll(magFreqDist, surface, rupOffset, rake, duration, sourceName);
    }

    public void setAll(IncrementalMagFreqDist magFreqDist, EvenlyGriddedSurface surface, double rupOffset, double rake, double duration, String sourceName) {
        this.magAreaRel = null;
        this.updateAll(magFreqDist, surface, rupOffset, rake, duration, sourceName);
    }

    public void setAll(IncrementalMagFreqDist magFreqDist, EvenlyGriddedSurface surface, double rupOffset, double rake, double duration, String sourceName, MagAreaRelationship magAreaRel) {
        this.magAreaRel = magAreaRel;
        this.updateAll(magFreqDist, surface, rupOffset, rake, duration, sourceName);
    }

    private void updateAll(IncrementalMagFreqDist magFreqDist, EvenlyGriddedSurface surface, double rupOffset, double rake, double duration, String sourceName) {
        this.surface = surface;
        this.rupOffset = rupOffset;
        this.rake = rake;
        this.duration = duration;
        this.name = sourceName;
        this.probEqkRupture = new ProbEqkRupture();
        this.probEqkRupture.setAveRake(rake);
        this.mags = new ArrayList();
        this.rates = new ArrayList();
        for (int i = 0; i < magFreqDist.getNum(); ++i) {
            if (!(magFreqDist.getY(i) > 0.0)) continue;
            this.mags.add(new Double(magFreqDist.getX(i)));
            this.rates.add(new Double(magFreqDist.getY(i)));
        }
        int numMags = this.mags.size();
        this.totNumRups = 0;
        for (int i = 0; i < numMags; ++i) {
            double rupLen = this.getRupLength((Double)this.mags.get(i));
            this.totNumRups += this.getNumRuptures(rupLen);
        }
    }

    public EvenlyGriddedSurface getSourceSurface() {
        return this.surface;
    }

    public int getNumRuptures() {
        return this.totNumRups;
    }

    public ProbEqkRupture getRupture(int nthRupture) {
        int numMags = this.mags.size();
        double mag = 0.0;
        double rupLen = 0.0;
        int numRups = 0;
        int tempNumRups = 0;
        int iMag = -1;
        if (nthRupture < 0 || nthRupture >= this.getNumRuptures()) {
            throw new RuntimeException("Invalid rupture index. This index does not exist");
        }
        for (int i = 0; i < numMags; ++i) {
            mag = (Double)this.mags.get(i);
            iMag = i;
            rupLen = this.getRupLength(mag);
            if (this.D) {
                System.out.println("mag=" + mag + "; rupLen=" + rupLen);
            }
            if (nthRupture < (tempNumRups += (numRups = this.getNumRuptures(rupLen)))) break;
        }
        this.probEqkRupture.setMag(mag);
        double rate = (Double)this.rates.get(iMag);
        double prob = 1.0 - Math.exp(-this.duration * rate / (double)numRups);
        this.probEqkRupture.setProbability(prob);
        this.probEqkRupture.setRuptureSurface(this.surface.getNthSubsetSurface(rupLen, 100.0, this.rupOffset, nthRupture + numRups - tempNumRups));
        return this.probEqkRupture;
    }

    public void setDuration(double yrs) {
        this.duration = yrs;
    }

    private double getRupLength(double mag) {
        if (this.magAreaRel == null) {
            return Math.pow(10.0, -3.22 + 0.69 * mag);
        }
        return this.magAreaRel.getMedianArea(mag) / this.surface.getSurfaceWidth();
    }

    private int getNumRuptures(double rupLen) {
        return this.surface.getNumSubsetSurfaces(rupLen, 100.0, this.rupOffset);
    }

    public double getMinDistance(Site site) {
        Direction dir = RelativeLocation.getDirection(site.getLocation(), (Location)this.surface.get(0, 0));
        double min = dir.getHorzDistance();
        if (min > (dir = RelativeLocation.getDirection(site.getLocation(), (Location)this.surface.get(0, this.surface.getNumCols() - 1))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        if (min > (dir = RelativeLocation.getDirection(site.getLocation(), (Location)this.surface.get(0, this.surface.getNumCols() / 2))).getHorzDistance()) {
            min = dir.getHorzDistance();
        }
        return min;
    }

    public String getName() {
        return this.name;
    }

    public static void main(String[] args) {
        FaultTrace fltTr = new FaultTrace("name");
        fltTr.addLocation(new Location(33.0, -122.0, 0.0));
        fltTr.addLocation(new Location(34.0, -122.0, 0.0));
        FrankelGriddedSurface surface = new FrankelGriddedSurface(fltTr, 90.0, 0.0, 10.0, 1.0);
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(6.5, 3, 0.5, 6.5, 7.5, 1.0E14, 1.0);
        System.out.println("cumRate=" + (float)gr.getTotCumRate());
        Frankel02_TypeB_EqkSource src = new Frankel02_TypeB_EqkSource(gr, surface, 10.0, 0.0, 1.0, "name");
        for (int i = 0; i < src.getNumRuptures(); ++i) {
            ProbEqkRupture rup = src.getRupture(i);
            System.out.print("rup #" + i + ":\n\tmag=" + rup.getMag() + "\n\tprob=" + rup.getProbability() + "\n\tRup Ends: " + (float)rup.getRuptureSurface().getLocation(0, 0).getLatitude() + "  " + (float)rup.getRuptureSurface().getLocation(0, rup.getRuptureSurface().getNumCols() - 1).getLatitude() + "\n\n");
        }
    }

    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        ListIterator it = this.surface.getAllByRowsIterator();
        while (it.hasNext()) {
            locList.addLocation((Location)it.next());
        }
        return locList;
    }
}

