/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data;

import java.io.FileWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.opensha.commons.data.Location;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data.A_FaultsFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data.FaultsFetcher;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data.SegRateConstraint;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data.SegmentTimeDepData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class B_FaultsFetcher
extends FaultsFetcher
implements Serializable {
    private A_FaultsFetcher aFaultsFetcher = null;
    private ArrayList bFaultNames;
    private ArrayList bFaultIds;
    private HashMap faultSegmentMap;
    private ArrayList allSpecialFaultIds;
    private static final String B_CONNECT_MINIMAL = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_3/data/B_FaultConnectionsMinimum.txt";
    private static final String B_CONNECT_MODEL1 = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_3/data/B_FaultConnectionsF2.1.txt";
    private static final String B_CONNECT_MODEL2 = "org/opensha/sha/earthquake/rupForecastImpl/WGCEP_UCERF_2_3/data/B_FaultConnectionsF2.2.txt";

    public B_FaultsFetcher() {
        PrefFaultSectionDataDB_DAO faultSectionPrefDAO = new PrefFaultSectionDataDB_DAO(DB_AccessAPI.dbConnection);
        faultSectionPrefDAO.getAllFaultSectionPrefData();
    }

    public void setDeformationModel(boolean isConnected, DeformationModelSummary defModelSummary, A_FaultsFetcher aFaultsFetcher) {
        this.deformationModelId = defModelSummary.getDeformationModelId();
        String fileName = null;
        if (!isConnected) {
            fileName = B_CONNECT_MINIMAL;
        } else {
            String faultModelName = defModelSummary.getFaultModel().getFaultModelName();
            if (faultModelName.equalsIgnoreCase("F2.1")) {
                fileName = B_CONNECT_MODEL1;
            } else if (faultModelName.equalsIgnoreCase("F2.2")) {
                fileName = B_CONNECT_MODEL2;
            } else {
                throw new RuntimeException("Unsupported Fault Model");
            }
        }
        this.aFaultsFetcher = aFaultsFetcher;
        this.loadSegmentModels(fileName);
        this.allSpecialFaultIds = super.getAllFaultSectionsIdList();
        this.generateBFaults();
    }

    private void generateBFaults() {
        this.faultSegmentMap = new HashMap();
        this.bFaultNames = new ArrayList();
        this.bFaultIds = new ArrayList();
        ArrayList faultSectionsInDefModel = this.deformationModelPrefDB_DAO.getFaultSectionIdsForDeformationModel(this.deformationModelId);
        ArrayList<Integer> aFaultsList = this.aFaultsFetcher.getAllFaultSectionsIdList();
        for (int i = 0; i < faultSectionsInDefModel.size(); ++i) {
            int faultSectionId;
            FaultSectionPrefData faultSectionPrefData;
            if (aFaultsList.contains(faultSectionsInDefModel.get(i)) || this.allSpecialFaultIds.contains(faultSectionsInDefModel.get(i)) || (faultSectionPrefData = this.deformationModelPrefDB_DAO.getFaultSectionPrefData(this.deformationModelId, faultSectionId = ((Integer)faultSectionsInDefModel.get(i)).intValue())).getAveLongTermSlipRate() == 0.0 || Double.isNaN(faultSectionPrefData.getAveLongTermSlipRate())) continue;
            this.bFaultNames.add(faultSectionPrefData.getSectionName());
            this.bFaultIds.add(new Integer(faultSectionPrefData.getSectionId()));
            ArrayList<FaultSectionPrefData> sectionList = new ArrayList<FaultSectionPrefData>();
            sectionList.add(faultSectionPrefData);
            ArrayList<ArrayList<FaultSectionPrefData>> segmentList = new ArrayList<ArrayList<FaultSectionPrefData>>();
            segmentList.add(sectionList);
            this.faultSegmentMap.put(faultSectionPrefData.getSectionName(), segmentList);
        }
        this.bFaultNames.addAll(super.getAllFaultNames());
        this.bFaultIds.addAll(super.getAllFaultSectionsIdList());
    }

    public ArrayList getAllFaultSectionsIdList() {
        return this.bFaultIds;
    }

    public ArrayList<Integer> getConnectedFaultSectionsIdList() {
        return super.getAllFaultSectionsIdList();
    }

    public ArrayList<String> getConnectedFaultSectionsNamesList() {
        return super.getAllFaultSectionsNamesList();
    }

    @Override
    public ArrayList<String> getAllFaultNames() {
        return this.bFaultNames;
    }

    @Override
    public ArrayList getFaultSegmentDataList(boolean isAseisReducesArea) {
        ArrayList<FaultSegmentData> faultList = new ArrayList<FaultSegmentData>();
        for (int i = 0; i < this.bFaultNames.size(); ++i) {
            faultList.add(this.getFaultSegmentData((String)this.bFaultNames.get(i), isAseisReducesArea));
        }
        return faultList;
    }

    @Override
    public ArrayList<SegRateConstraint> getSegRateConstraints(String selectedSegmentModel) {
        return null;
    }

    @Override
    public ArrayList<SegmentTimeDepData> getSegTimeDepData(String faultName) {
        return null;
    }

    public void test_writeFileAfterCombiningB_Faults(boolean isAseisReducesArea) {
        try {
            FileWriter fwTrace = new FileWriter("Combined_Conn_B-Faults.txt");
            fwTrace.write("#SectionName,AvgUppeSeisDepth, AvgLowerSeisDepth, AveDip\n");
            for (int index = 0; index < this.bFaultNames.size(); ++index) {
                FaultSegmentData faultSegmentData = this.getFaultSegmentData((String)this.bFaultNames.get(index), false);
                ArrayList faultSectionPredDataList = faultSegmentData.getPrefFaultSectionDataList();
                if (faultSectionPredDataList.size() < 2) continue;
                ArrayList<SimpleFaultData> simpleFaultData = new ArrayList<SimpleFaultData>();
                for (int i = 0; i < faultSectionPredDataList.size(); ++i) {
                    simpleFaultData.add(((FaultSectionPrefData)faultSectionPredDataList.get(i)).getSimpleFaultData(isAseisReducesArea));
                }
                StirlingGriddedSurface surface = new StirlingGriddedSurface(simpleFaultData, 1.0);
                fwTrace.write("#" + (String)this.bFaultNames.get(index) + "," + surface.getUpperSeismogenicDepth() + "," + surface.getLowerSeismogenicDepth() + "," + surface.getAveDip() + "\n");
                FaultTrace faultTrace = surface.getFaultTrace();
                int numFaultTraceLocations = faultTrace.getNumLocations();
                double upperSeisDepth = surface.getUpperSeismogenicDepth();
                for (int j = 0; j < numFaultTraceLocations; ++j) {
                    Location loc = faultTrace.getLocationAt(j);
                    fwTrace.write(loc.getLongitude() + "\t" + loc.getLatitude() + "\t" + upperSeisDepth + "\n");
                }
            }
            fwTrace.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public FaultSegmentData getFaultSegmentData(String faultModel, boolean isAseisReducesArea) {
        ArrayList segmentList = (ArrayList)this.faultSegmentMap.get(faultModel);
        if (segmentList != null) {
            return new FaultSegmentData(segmentList, null, isAseisReducesArea, faultModel, null, null);
        }
        FaultSegmentData faultSegmentData = super.getFaultSegmentData(faultModel, isAseisReducesArea);
        return faultSegmentData;
    }

    public static void main(String[] args) {
        B_FaultsFetcher b = new B_FaultsFetcher();
        ArrayList bFaults = b.getFaultSegmentDataList(true);
        ArrayList preFaultSectionDataList = new ArrayList();
        for (int i = 0; i < bFaults.size(); ++i) {
            FaultSegmentData faultSegmentData = (FaultSegmentData)bFaults.get(i);
            preFaultSectionDataList.addAll(faultSegmentData.getPrefFaultSectionDataList());
        }
    }
}

