/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.opensha.commons.util.FileUtils;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelPrefDataDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.FaultSegmentData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data.SegRateConstraint;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_3.data.SegmentTimeDepData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FaultsFetcher {
    protected HashMap faultModels;
    private PrefFaultSectionDataDB_DAO faultSectionDAO = new PrefFaultSectionDataDB_DAO(DB_AccessAPI.dbConnection);
    protected DeformationModelPrefDataDB_DAO deformationModelPrefDB_DAO = new DeformationModelPrefDataDB_DAO(DB_AccessAPI.dbConnection);
    private static final String FAULT_MODEL_NAME_PREFIX = "-";
    protected ArrayList<String> faultModelNames = new ArrayList();
    protected HashMap segmentNamesMap = new HashMap();
    protected int deformationModelId = -1;
    private ArrayList faultDataListInSelectedSegment = null;
    private static final int GLEN_IVY_STEPOVER_FAULT_SECTION_ID = 297;
    private static final int TEMECULA_STEPOVER_FAULT_SECTION_ID = 298;
    private static final int ELSINORE_COMBINED_STEPOVER_FAULT_SECTION_ID = 402;
    private static final int SJ_VALLEY_STEPOVER_FAULT_SECTION_ID = 290;
    private static final int SJ_ANZA_STEPOVER_FAULT_SECTION_ID = 291;
    private static final int SJ_COMBINED_STEPOVER_FAULT_SECTION_ID = 401;
    protected boolean isUnsegmented = false;

    public FaultsFetcher() {
    }

    public FaultsFetcher(String fileName) {
        this.loadSegmentModels(fileName);
    }

    public void loadSegmentModels(String fileName) {
        this.faultModelNames = new ArrayList();
        this.faultModels = new HashMap();
        try {
            ArrayList<String> fileLines = FileUtils.loadJarFile(fileName);
            ArrayList<ArrayList> segmentsList = null;
            String faultModelName = null;
            for (int i = 0; i < fileLines.size(); ++i) {
                String line = fileLines.get(i).trim();
                if (line.equalsIgnoreCase("") || line.startsWith("#")) continue;
                if (line.startsWith(FAULT_MODEL_NAME_PREFIX)) {
                    if (faultModelName != null) {
                        this.faultModels.put(faultModelName, segmentsList);
                    }
                    faultModelName = this.getSegmentModelName(line);
                    this.faultModelNames.add(faultModelName);
                    segmentsList = new ArrayList<ArrayList>();
                    continue;
                }
                segmentsList.add(this.getSegment(line));
            }
            this.faultModels.put(faultModelName, segmentsList);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ArrayList getFaultSegmentDataList(boolean isAseisReducesArea) {
        ArrayList<FaultSegmentData> faultSegDataList = new ArrayList<FaultSegmentData>();
        for (int i = 0; i < this.faultModelNames.size(); ++i) {
            faultSegDataList.add(this.getFaultSegmentData(this.faultModelNames.get(i), isAseisReducesArea));
        }
        return faultSegDataList;
    }

    public ArrayList<Integer> getAllFaultSectionsIdList() {
        ArrayList<Integer> faultSectionIdList = new ArrayList<Integer>();
        for (int i = 0; i < this.faultModelNames.size(); ++i) {
            faultSectionIdList.addAll(this.getFaultSectionsIdList(this.faultModelNames.get(i)));
        }
        return faultSectionIdList;
    }

    private ArrayList<Integer> getFaultSectionsIdList(String faultModel) {
        ArrayList segmentsList = (ArrayList)this.faultModels.get(faultModel);
        ArrayList<Integer> faultSectionIdList = new ArrayList<Integer>();
        for (int i = 0; i < segmentsList.size(); ++i) {
            ArrayList segment = (ArrayList)segmentsList.get(i);
            for (int j = 0; j < segment.size(); ++j) {
                int faultSectionId = ((FaultSectionSummary)segment.get(j)).getSectionId();
                faultSectionIdList.add(faultSectionId);
            }
        }
        return faultSectionIdList;
    }

    public ArrayList<String> getAllFaultSectionsNamesList() {
        ArrayList<String> faultSectionsNamesList = new ArrayList<String>();
        for (int i = 0; i < this.faultModelNames.size(); ++i) {
            faultSectionsNamesList.addAll(this.getFaultSectionsNamesList(this.faultModelNames.get(i)));
        }
        return faultSectionsNamesList;
    }

    private ArrayList<String> getFaultSectionsNamesList(String faultModel) {
        ArrayList segmentsList = (ArrayList)this.faultModels.get(faultModel);
        ArrayList<String> faultSectionsNamesList = new ArrayList<String>();
        for (int i = 0; i < segmentsList.size(); ++i) {
            ArrayList segment = (ArrayList)segmentsList.get(i);
            for (int j = 0; j < segment.size(); ++j) {
                String faultSectionName = ((FaultSectionSummary)segment.get(j)).getSectionName();
                faultSectionsNamesList.add(faultSectionName);
            }
        }
        return faultSectionsNamesList;
    }

    public FaultSegmentData getFaultSegmentData(String faultName, boolean isAseisReducesArea) {
        ArrayList segmentsList = (ArrayList)this.faultModels.get(faultName);
        this.faultDataListInSelectedSegment = new ArrayList();
        for (int i = 0; i < segmentsList.size(); ++i) {
            ArrayList sectionList = (ArrayList)segmentsList.get(i);
            ArrayList<FaultSectionPrefData> newSegment = new ArrayList<FaultSectionPrefData>();
            for (int j = 0; j < sectionList.size(); ++j) {
                int faultSectionId = ((FaultSectionSummary)sectionList.get(j)).getSectionId();
                FaultSectionPrefData faultSectionPrefData = this.deformationModelPrefDB_DAO.getFaultSectionPrefData(this.deformationModelId, faultSectionId);
                if (Double.isNaN(faultSectionPrefData.getAveLongTermSlipRate()) || this.isUnsegmented && faultName.equalsIgnoreCase("Elsinore") && faultSectionPrefData.getSectionId() == 298) continue;
                if (this.isUnsegmented && faultName.equalsIgnoreCase("Elsinore") && faultSectionPrefData.getSectionId() == 297) {
                    FaultSectionPrefData glenIvyStepoverfaultSectionPrefData = this.deformationModelPrefDB_DAO.getFaultSectionPrefData(this.deformationModelId, 297);
                    FaultSectionPrefData temeculaStepoverfaultSectionPrefData = this.deformationModelPrefDB_DAO.getFaultSectionPrefData(this.deformationModelId, 298);
                    faultSectionPrefData = this.faultSectionDAO.getFaultSectionPrefData(402);
                    faultSectionPrefData.setAveLongTermSlipRate(glenIvyStepoverfaultSectionPrefData.getAveLongTermSlipRate() + temeculaStepoverfaultSectionPrefData.getAveLongTermSlipRate());
                    faultSectionPrefData.setSlipRateStdDev(glenIvyStepoverfaultSectionPrefData.getSlipRateStdDev() + temeculaStepoverfaultSectionPrefData.getSlipRateStdDev());
                }
                if (this.isUnsegmented && faultName.equalsIgnoreCase("San Jacinto (SB to C)")) {
                    if (faultSectionPrefData.getSectionId() == 291) continue;
                }
                if (this.isUnsegmented && faultName.equalsIgnoreCase("San Jacinto (SB to C)")) {
                    if (faultSectionPrefData.getSectionId() == 290) {
                        FaultSectionPrefData anzaStepoverfaultSectionPrefData = this.deformationModelPrefDB_DAO.getFaultSectionPrefData(this.deformationModelId, 291);
                        FaultSectionPrefData valleyStepoverfaultSectionPrefData = this.deformationModelPrefDB_DAO.getFaultSectionPrefData(this.deformationModelId, 290);
                        faultSectionPrefData = this.faultSectionDAO.getFaultSectionPrefData(401);
                        faultSectionPrefData.setAveLongTermSlipRate(anzaStepoverfaultSectionPrefData.getAveLongTermSlipRate() + valleyStepoverfaultSectionPrefData.getAveLongTermSlipRate());
                        faultSectionPrefData.setSlipRateStdDev(anzaStepoverfaultSectionPrefData.getSlipRateStdDev() + valleyStepoverfaultSectionPrefData.getSlipRateStdDev());
                    }
                }
                newSegment.add(faultSectionPrefData);
            }
            this.faultDataListInSelectedSegment.add(newSegment);
        }
        ArrayList<SegRateConstraint> segRates = this.getSegRateConstraints(faultName);
        ArrayList<SegmentTimeDepData> segTimeDepDataList = this.getSegTimeDepData(faultName);
        FaultSegmentData segmetedFaultData = new FaultSegmentData(this.faultDataListInSelectedSegment, (String[])this.segmentNamesMap.get(faultName), isAseisReducesArea, faultName, segRates, segTimeDepDataList);
        return segmetedFaultData;
    }

    public ArrayList<String> getAllFaultNames() {
        return this.faultModelNames;
    }

    public abstract ArrayList<SegRateConstraint> getSegRateConstraints(String var1);

    public abstract ArrayList<SegmentTimeDepData> getSegTimeDepData(String var1);

    private String getSegmentModelName(String line) {
        int index = line.indexOf(FAULT_MODEL_NAME_PREFIX);
        return line.substring(index + 1).trim();
    }

    private ArrayList getSegment(String line) {
        line = line.substring(0, line.indexOf(58));
        ArrayList<FaultSectionSummary> faultSectionsIdList = new ArrayList<FaultSectionSummary>();
        StringTokenizer tokenizer = new StringTokenizer(line, "\n,");
        while (tokenizer.hasMoreTokens()) {
            FaultSectionPrefData faultSectionPrefData = this.faultSectionDAO.getFaultSectionPrefData(Integer.parseInt(tokenizer.nextToken().trim()));
            faultSectionsIdList.add(new FaultSectionSummary(faultSectionPrefData.getSectionId(), faultSectionPrefData.getSectionName()));
        }
        return faultSectionsIdList;
    }
}

