/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.commons.data.Location;
import org.opensha.commons.exceptions.FaultException;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EvenlyGriddedSurfFromSimpleFaultData
extends EvenlyGriddedSurface {
    protected static final String C = "EvenlyGriddedSurfFromSimpleFaultData";
    protected static final boolean D = false;
    protected FaultTrace faultTrace;
    protected double upperSeismogenicDepth = Double.NaN;
    protected double lowerSeismogenicDepth = Double.NaN;

    protected EvenlyGriddedSurfFromSimpleFaultData(SimpleFaultData simpleFaultData, double gridSpacing) throws FaultException {
        this(simpleFaultData.getFaultTrace(), simpleFaultData.getAveDip(), simpleFaultData.getUpperSeismogenicDepth(), simpleFaultData.getLowerSeismogenicDepth(), gridSpacing);
    }

    protected EvenlyGriddedSurfFromSimpleFaultData(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing) throws FaultException {
        this.set(faultTrace, aveDip, upperSeismogenicDepth, lowerSeismogenicDepth, gridSpacing);
    }

    private void set(FaultTrace faultTrace, double aveDip, double upperSeismogenicDepth, double lowerSeismogenicDepth, double gridSpacing) {
        this.faultTrace = faultTrace;
        this.aveDip = aveDip;
        this.upperSeismogenicDepth = upperSeismogenicDepth;
        this.lowerSeismogenicDepth = lowerSeismogenicDepth;
        this.gridSpacing = gridSpacing;
    }

    protected EvenlyGriddedSurfFromSimpleFaultData(ArrayList<SimpleFaultData> simpleFaultDataList, double gridSpacing) {
        SimpleFaultData simpleFaultData = SimpleFaultData.getCombinedSimpleFaultData(simpleFaultDataList);
        this.set(simpleFaultData.getFaultTrace(), simpleFaultData.getAveDip(), simpleFaultData.getUpperSeismogenicDepth(), simpleFaultData.getLowerSeismogenicDepth(), gridSpacing);
    }

    protected void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    protected void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    public FaultTrace getFaultTrace() {
        return this.faultTrace;
    }

    public double getUpperSeismogenicDepth() {
        return this.upperSeismogenicDepth;
    }

    public double getLowerSeismogenicDepth() {
        return this.lowerSeismogenicDepth;
    }

    protected void assertValidData() throws FaultException {
        if (this.faultTrace == null) {
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultDataFault Trace is null");
        }
        FaultUtils.assertValidDip(this.aveDip);
        FaultUtils.assertValidSeisUpperAndLower(this.upperSeismogenicDepth, this.lowerSeismogenicDepth);
        if (this.gridSpacing == Double.NaN) {
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultDatainvalid gridSpacing");
        }
        double depth = this.faultTrace.getLocationAt(0).getDepth();
        if (depth > this.upperSeismogenicDepth) {
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultDatadepth on faultTrace locations must be < upperSeisDepth");
        }
        Iterator<Location> it = this.faultTrace.iterator();
        while (it.hasNext()) {
            if (it.next().getDepth() == depth) continue;
            throw new FaultException("EvenlyGriddedSurfFromSimpleFaultData:All depth on faultTrace locations must be equal");
        }
    }
}

