/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.faultSurface;

import java.util.Iterator;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.NamedObjectAPI;

public class FaultTrace
extends LocationList
implements NamedObjectAPI {
    private String faultName;
    private static final String TAB = "  ";

    public FaultTrace(String faultName) {
        this.faultName = faultName;
    }

    public void setName(String faultName) {
        this.faultName = faultName;
    }

    public String getName() {
        return this.faultName;
    }

    public int getNumLocations() {
        return this.size();
    }

    public double getTraceLength() {
        double totLength = 0.0;
        Iterator<Location> it = this.iterator();
        Location lastLoc = it.next();
        Location loc = null;
        while (it.hasNext()) {
            loc = it.next();
            totLength += RelativeLocation.getHorzDistance(lastLoc, loc);
            lastLoc = loc;
        }
        return totLength;
    }

    public double getAveStrike() {
        double totLength = 0.0;
        double length = 0.0;
        Iterator<Location> it = this.iterator();
        Location lastLoc = it.next();
        Location loc = null;
        double aveStrike = 0.0;
        while (it.hasNext()) {
            loc = it.next();
            length = RelativeLocation.getHorzDistance(lastLoc, loc);
            aveStrike += RelativeLocation.getAzimuth(lastLoc, loc) * length;
            totLength += length;
            lastLoc = loc;
        }
        throw new RuntimeException("This needs to be fixed for case where aximuths that cross the north direction (e.g., values of 10 & 350 average to 180");
    }

    public double getStrikeDirection() {
        return RelativeLocation.getAzimuth(this.getLocationAt(0), this.getLocationAt(this.size() - 1));
    }

    public double getStrikeDirectionDifference(FaultTrace trace) {
        double diff = trace.getStrikeDirection() - this.getStrikeDirection();
        if (diff > 180.0) {
            return diff - 360.0;
        }
        if (diff < -180.0) {
            return diff + 360.0;
        }
        return diff;
    }

    public double getMinDistance(FaultTrace faultTrace) {
        double minFaultTraceDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < faultTrace.getNumLocations(); ++i) {
            double dist = this.getMinHorzDistToLine(faultTrace.getLocationAt(i));
            if (!(dist < minFaultTraceDist)) continue;
            minFaultTraceDist = dist;
        }
        return minFaultTraceDist;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("LocationList");
        b.append('\n');
        b.append("  Name = " + this.faultName);
        b.append(super.toString());
        return b.toString();
    }
}

