/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import org.jfree.data.Range;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.sha.gui.infoTools.GraphWindow;
import org.opensha.sha.gui.infoTools.GraphWindowAPI;
import org.opensha.sha.gui.infoTools.PlotCurveCharacterstics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphiWindowAPI_Impl
implements GraphWindowAPI {
    private ArrayList funcs;
    private final PlotCurveCharacterstics PLOT_CHAR1 = new PlotCurveCharacterstics("Solid Line", Color.BLUE, 2.0);
    private final PlotCurveCharacterstics PLOT_CHAR2 = new PlotCurveCharacterstics("Solid Line", Color.BLACK, 2.0);
    private final PlotCurveCharacterstics PLOT_CHAR3 = new PlotCurveCharacterstics("Solid Line", Color.GREEN, 2.0);
    private final PlotCurveCharacterstics PLOT_CHAR4 = new PlotCurveCharacterstics("Solid Line", Color.MAGENTA, 2.0);
    private final PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics("Solid Line", Color.PINK, 2.0);
    private final PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics("Solid Line", Color.LIGHT_GRAY, 5.0);
    private final PlotCurveCharacterstics PLOT_CHAR7 = new PlotCurveCharacterstics("Solid Line", Color.RED, 2.0);
    private boolean xLog = false;
    private boolean yLog = false;
    private ArrayList<PlotCurveCharacterstics> plotChars;
    private String plotTitle;
    private GraphWindow graphWindow;
    private boolean isCustomAxis = false;

    public GraphiWindowAPI_Impl(ArrayList funcs, String plotTitle) {
        this.funcs = funcs;
        ArrayList<PlotCurveCharacterstics> list = new ArrayList<PlotCurveCharacterstics>();
        list.add(this.PLOT_CHAR1);
        list.add(this.PLOT_CHAR2);
        list.add(this.PLOT_CHAR3);
        list.add(this.PLOT_CHAR4);
        list.add(this.PLOT_CHAR5);
        list.add(this.PLOT_CHAR6);
        list.add(this.PLOT_CHAR7);
        int numChars = list.size();
        this.plotChars = new ArrayList();
        for (int i = 0; i < funcs.size(); ++i) {
            this.plotChars.add((PlotCurveCharacterstics)list.get(i % numChars));
        }
        this.graphWindow = new GraphWindow(this);
        this.graphWindow.setPlotLabel(plotTitle);
        this.graphWindow.plotGraphUsingPlotPreferences();
        this.graphWindow.setVisible(true);
    }

    public GraphiWindowAPI_Impl(ArrayList funcs, String plotTitle, ArrayList<PlotCurveCharacterstics> plotChars) {
        this.funcs = funcs;
        this.plotChars = plotChars;
        this.graphWindow = new GraphWindow(this);
        this.graphWindow.setPlotLabel(plotTitle);
        this.graphWindow.plotGraphUsingPlotPreferences();
        this.graphWindow.setVisible(true);
    }

    public void refreshPlot() {
        this.graphWindow.plotGraphUsingPlotPreferences();
    }

    public void setPlotTitle(String plotTitle) {
        this.plotTitle = plotTitle;
        this.graphWindow.setPlotLabel(plotTitle);
    }

    public String getPlotTitle() {
        return this.plotTitle;
    }

    @Override
    public ArrayList getCurveFunctionList() {
        return this.funcs;
    }

    public void setXLog(boolean xLog) {
        this.xLog = xLog;
        this.graphWindow.setX_Log(xLog);
    }

    public void setYLog(boolean yLog) {
        this.yLog = yLog;
        this.graphWindow.setY_Log(yLog);
    }

    @Override
    public boolean getXLog() {
        return this.xLog;
    }

    @Override
    public boolean getYLog() {
        return this.yLog;
    }

    public void setX_AxisLabel(String xAxisLabel) {
        this.graphWindow.setXAxisLabel(xAxisLabel);
    }

    @Override
    public String getXAxisLabel() {
        if (this.graphWindow == null) {
            return "X";
        }
        return this.graphWindow.getXAxisLabel();
    }

    public void setY_AxisLabel(String yAxisLabel) {
        this.graphWindow.setYAxisLabel(yAxisLabel);
    }

    @Override
    public String getYAxisLabel() {
        if (this.graphWindow == null) {
            return "Y";
        }
        return this.graphWindow.getYAxisLabel();
    }

    @Override
    public ArrayList getPlottingFeatures() {
        return this.plotChars;
    }

    public void setPlottingFeatures(ArrayList<PlotCurveCharacterstics> curveCharacteristics) {
        this.plotChars = curveCharacteristics;
        this.graphWindow.setPlottingFeatures(curveCharacteristics);
    }

    public void setAxisRange(double xMin, double xMax, double yMin, double yMax) {
        this.graphWindow.setAxisRange(xMin, xMax, yMin, yMax);
        this.isCustomAxis = true;
    }

    public void setX_AxisRange(double xMin, double xMax) {
        Range yAxisRange = this.graphWindow.getY_AxisRange();
        this.setAxisRange(xMin, xMax, yAxisRange.getLowerBound(), yAxisRange.getUpperBound());
    }

    public void setY_AxisRange(double yMin, double yMax) {
        Range xAxisRange = this.graphWindow.getX_AxisRange();
        this.setAxisRange(xAxisRange.getLowerBound(), xAxisRange.getUpperBound(), yMin, yMax);
    }

    @Override
    public boolean isCustomAxis() {
        return this.isCustomAxis;
    }

    public void setAutoRange() {
        this.isCustomAxis = false;
        this.graphWindow.setAutoRange();
    }

    @Override
    public double getMinX() {
        return this.graphWindow.getMinX();
    }

    @Override
    public double getMaxX() {
        return this.graphWindow.getMaxX();
    }

    @Override
    public double getMinY() {
        return this.graphWindow.getMinY();
    }

    @Override
    public double getMaxY() {
        return this.graphWindow.getMaxY();
    }

    public void setPlotLabelFontSize(int fontSize) {
        this.graphWindow.setPlotLabelFontSize(fontSize);
    }

    public void setTickLabelFontSize(int fontSize) {
        this.graphWindow.setTickLabelFontSize(fontSize);
    }

    public void setAxisAndTickLabelFontSize(int fontSize) {
        this.graphWindow.setAxisLabelFontSize(fontSize);
        this.graphWindow.setTickLabelFontSize(fontSize);
    }

    public int getTickLabelFontSize() {
        return this.graphWindow.getTickLabelFontSize();
    }

    public int getPlotLabelFontSize() {
        return this.graphWindow.getPlotLabelFontSize();
    }

    public static void main(String[] args) {
        ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(2.0, 3.0);
        func.set(0.5, 3.5);
        func.set(6.0, 1.0);
        funcs.add(func);
        func = new ArbitrarilyDiscretizedFunc();
        func.set(1.0, 6.0);
        func.set(10.0, 7.0);
        func.set(2.0, 2.0);
        funcs.add(func);
        GraphiWindowAPI_Impl graphWindowImpl = new GraphiWindowAPI_Impl(funcs, "Test");
        graphWindowImpl.setPlotTitle("Test Title");
        graphWindowImpl.setX_AxisRange(0.0, 5.0);
        graphWindowImpl.setAutoRange();
        PlotCurveCharacterstics PLOT_CHAR5 = new PlotCurveCharacterstics("Solid Line", Color.PINK, 2.0);
        PlotCurveCharacterstics PLOT_CHAR6 = new PlotCurveCharacterstics("Solid Line", Color.LIGHT_GRAY, 5.0);
        ArrayList<PlotCurveCharacterstics> list = new ArrayList<PlotCurveCharacterstics>();
        list.add(PLOT_CHAR5);
        list.add(PLOT_CHAR6);
        graphWindowImpl.setPlottingFeatures(list);
    }

    public void saveAsPDF(String fileName) throws IOException {
        this.graphWindow.saveAsPDF(fileName);
    }

    public void saveAsPNG(String fileName) throws IOException {
        this.graphWindow.saveAsPNG(fileName);
    }
}

