/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.DoubleDiscreteConstraint;
import org.opensha.commons.param.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.PropagationEffect;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class BJF_1997_AttenRel
extends AttenuationRelationship
implements ScalarIntensityMeasureRelationshipAPI,
NamedObjectAPI {
    private static final String C = "BJF_1997_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Boore, Joyner & Fumal (1997)";
    public static final String SHORT_NAME = "BJF1997";
    private static final long serialVersionUID = 1234567890987654355L;
    public static final String FLT_TYPE_UNKNOWN = "Unknown";
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    protected static final Double VS30_WARN_MIN = new Double(180.0);
    protected static final Double VS30_WARN_MAX = new Double(3500.0);
    protected static final Double MAG_WARN_MIN = new Double(5.5);
    protected static final Double MAG_WARN_MAX = new Double(7.5);
    protected static final Double DISTANCE_JB_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_JB_WARN_MAX = new Double(80.0);
    private BJF_1997_AttenRelCoefficients coeff = null;
    protected Hashtable coefficients = new Hashtable();
    private transient ParameterChangeWarningListener warningListener = null;

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        FaultUtils.assertValidRake(rake);
        if (Math.abs(Math.sin(rake * Math.PI / 180.0)) <= 0.5) {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        } else if (rake >= 30.0 && rake <= 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_UNKNOWN);
        }
    }

    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    public void setPropagationEffect(PropagationEffect propEffect) throws InvalidRangeException, ParameterException {
        this.site = propEffect.getSite();
        this.eqkRupture = propEffect.getEqkRupture();
        this.vs30Param.setValueIgnoreWarning((Double)this.site.getParameter("Vs30").getValue());
        this.magParam.setValueIgnoreWarning(new Double(this.eqkRupture.getMag()));
        this.setFaultTypeFromRake(this.eqkRupture.getAveRake());
        propEffect.setParamValue(this.distanceJBParam);
    }

    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void updateCoefficients() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("BJF_1997_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        StringBuffer key = new StringBuffer(this.im.getName());
        if (this.im.getName().equalsIgnoreCase("SA")) {
            key.append("/" + this.saPeriodParam.getValue());
        }
        if (!this.coefficients.containsKey(key.toString())) {
            throw new ParameterException("BJF_1997_AttenRel: setIntensityMeasureType(): Unable to locate coefficients with key = " + key);
        }
        this.coeff = (BJF_1997_AttenRelCoefficients)this.coefficients.get(key.toString());
    }

    public BJF_1997_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initCoefficients();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    public double getMean() throws IMRException {
        double b1;
        String fltTypeValue;
        double distanceJB;
        double vs30;
        double mag;
        try {
            mag = (Double)this.magParam.getValue();
            vs30 = (Double)this.vs30Param.getValue();
            distanceJB = (Double)this.distanceJBParam.getValue();
            fltTypeValue = ((String)this.fltTypeParam.getValue()).toString();
        }
        catch (NullPointerException e) {
            throw new IMRException("BJF_1997_AttenRel: getMean(): Not all parameters have been set");
        }
        if (distanceJB > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        this.updateCoefficients();
        if (fltTypeValue.equals(FLT_TYPE_STRIKE_SLIP)) {
            b1 = this.coeff.b1ss;
        } else if (fltTypeValue.equals(FLT_TYPE_REVERSE)) {
            b1 = this.coeff.b1rv;
        } else if (fltTypeValue.equals(FLT_TYPE_UNKNOWN)) {
            b1 = this.coeff.b1all;
        } else {
            throw new ParameterException("BJF_1997_AttenRel: getMean(): Invalid EqkRupture Parameter value for : FaultType");
        }
        double mean = b1 + this.coeff.b2 * (mag - 6.0) + this.coeff.b3 * Math.pow(mag - 6.0, 2.0) + this.coeff.b5 * Math.log(Math.pow(distanceJB * distanceJB + this.coeff.h * this.coeff.h, 0.5)) + this.coeff.bv * Math.log(vs30 / (double)this.coeff.va);
        return mean;
    }

    public double getStdDev() throws IMRException {
        String stdDevType = ((String)this.stdDevTypeParam.getValue()).toString();
        String component = ((String)this.componentParam.getValue()).toString();
        this.updateCoefficients();
        if (component.equals("Average Horizontal")) {
            if (stdDevType.equals("Total")) {
                return Math.pow(this.coeff.sigmaE * this.coeff.sigmaE + this.coeff.sigma1 * this.coeff.sigma1, 0.5);
            }
            if (stdDevType.equals("Inter-Event")) {
                return this.coeff.sigmaE;
            }
            if (stdDevType.equals("Intra-Event")) {
                return this.coeff.sigma1;
            }
            if (stdDevType.equals("None (zero)")) {
                return 0.0;
            }
            throw new ParameterException("BJF_1997_AttenRel: getStdDev(): Invalid StdDevType");
        }
        if (component.equals("Random Horizontal")) {
            if (stdDevType.equals("Total")) {
                return this.coeff.sigmaLnY;
            }
            if (stdDevType.equals("Inter-Event")) {
                return this.coeff.sigmaE;
            }
            if (stdDevType.equals("Intra-Event")) {
                return Math.pow(this.coeff.sigmaLnY * this.coeff.sigmaLnY - this.coeff.sigmaE * this.coeff.sigmaE, 0.5);
            }
            if (stdDevType.equals("None (zero)")) {
                return 0.0;
            }
            throw new ParameterException("BJF_1997_AttenRel: getStdDev(): Invalid StdDevType");
        }
        throw new ParameterException("BJF_1997_AttenRel: getStdDev(): Invalid component type");
    }

    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.distanceJBParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.distanceJBParam);
        this.exceedProbIndependentParams.addParameter(this.vs30Param);
        this.exceedProbIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.addParameter(this.fltTypeParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_UNKNOWN);
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_UNKNOWN);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter(0.0);
        this.distanceJBParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_JB_WARN_MIN, DISTANCE_JB_WARN_MAX);
        warn.setNonEditable();
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
    }

    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        TreeSet<Double> set = new TreeSet<Double>();
        Enumeration keys = this.coefficients.keys();
        while (keys.hasMoreElements()) {
            BJF_1997_AttenRelCoefficients coeff = (BJF_1997_AttenRelCoefficients)this.coefficients.get(keys.nextElement());
            if (!(coeff.period >= 0.0)) continue;
            set.add(new Double(coeff.period));
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            periodConstraint.addDouble((Double)it.next());
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.addString("Random Horizontal");
        constraint.setNonEditable();
        this.componentParam = new ComponentParam(constraint, "Average Horizontal");
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    protected void initCoefficients() {
        String S = "BJF_1997_AttenRel: initCoefficients():";
        this.coefficients.clear();
        BJF_1997_AttenRelCoefficients coeff = new BJF_1997_AttenRelCoefficients("PGA", 0.0, -0.313, -0.117, -0.242, 0.527, 0.0, -0.778, -0.371, 1396, 5.57, 0.431, 0.226, 0.486, 0.184, 0.52);
        BJF_1997_AttenRelCoefficients coeff0 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.00"), 0.0, -0.313, -0.117, -0.242, 0.527, 0.0, -0.778, -0.371, 1396, 5.57, 0.431, 0.226, 0.486, 0.184, 0.52);
        BJF_1997_AttenRelCoefficients coeff1 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.10"), 0.1, 1.006, 1.087, 1.059, 0.753, -0.226, -0.934, -0.212, 1112, 6.27, 0.44, 0.189, 0.479, 0.0, 0.479);
        BJF_1997_AttenRelCoefficients coeff2 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.11"), 0.11, 1.072, 1.164, 1.13, 0.732, -0.23, -0.937, -0.211, 1291, 6.65, 0.437, 0.2, 0.481, 0.0, 0.481);
        BJF_1997_AttenRelCoefficients coeff3 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.12"), 0.12, 1.109, 1.215, 1.174, 0.721, -0.233, -0.939, -0.215, 1452, 6.91, 0.437, 0.21, 0.485, 0.0, 0.485);
        BJF_1997_AttenRelCoefficients coeff4 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.13"), 0.13, 1.128, 1.246, 1.2, 0.711, -0.233, -0.939, -0.221, 1596, 7.08, 0.435, 0.216, 0.486, 0.0, 0.486);
        BJF_1997_AttenRelCoefficients coeff5 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.14"), 0.14, 1.135, 1.261, 1.208, 0.707, -0.23, -0.938, -0.228, 1718, 7.18, 0.435, 0.223, 0.489, 0.0, 0.489);
        BJF_1997_AttenRelCoefficients coeff6 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.15"), 0.15, 1.128, 1.264, 1.204, 0.702, -0.228, -0.937, -0.238, 1820, 7.23, 0.435, 0.23, 0.492, 0.0, 0.492);
        BJF_1997_AttenRelCoefficients coeff7 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.16"), 0.16, 1.112, 1.257, 1.192, 0.702, -0.226, -0.935, -0.248, 1910, 7.24, 0.435, 0.235, 0.495, 0.0, 0.495);
        BJF_1997_AttenRelCoefficients coeff8 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.17"), 0.17, 1.09, 1.242, 1.173, 0.702, -0.221, -0.933, -0.258, 1977, 7.21, 0.435, 0.293, 0.497, 0.0, 0.497);
        BJF_1997_AttenRelCoefficients coeff9 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.18"), 0.18, 1.063, 1.222, 1.151, 0.705, -0.216, -0.93, -0.27, 2037, 7.16, 0.435, 0.244, 0.499, 0.002, 0.499);
        BJF_1997_AttenRelCoefficients coeff10 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.19"), 0.19, 1.032, 1.198, 1.122, 0.709, -0.212, -0.927, -0.281, 2080, 7.1, 0.435, 0.294, 0.501, 0.005, 0.501);
        BJF_1997_AttenRelCoefficients coeff11 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.20"), 0.2, 0.999, 1.17, 1.089, 0.711, -0.207, -0.924, -0.292, 2118, 7.02, 0.435, 0.251, 0.502, 0.009, 0.502);
        BJF_1997_AttenRelCoefficients coeff12 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.22"), 0.22, 0.925, 1.104, 1.019, 0.721, -0.198, -0.918, -0.315, 2158, 6.83, 0.437, 0.285, 0.508, 0.016, 0.508);
        BJF_1997_AttenRelCoefficients coeff13 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.24"), 0.24, 0.847, 1.033, 0.941, 0.732, -0.189, -0.912, -0.338, 2178, 6.62, 0.437, 0.262, 0.51, 0.025, 0.511);
        BJF_1997_AttenRelCoefficients coeff14 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.26"), 0.26, 0.764, 0.958, 0.861, 0.744, -0.18, -0.906, -0.36, 2173, 6.39, 0.437, 0.267, 0.513, 0.032, 0.514);
        BJF_1997_AttenRelCoefficients coeff15 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.28"), 0.28, 0.681, 0.881, 0.78, 0.758, -0.168, -0.899, -0.381, 2158, 6.17, 0.44, 0.272, 0.517, 0.039, 0.518);
        BJF_1997_AttenRelCoefficients coeff16 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.30"), 0.3, 0.598, 0.803, 0.7, 0.769, -0.161, -0.893, -0.401, 2133, 5.94, 0.44, 0.276, 0.519, 0.048, 0.522);
        BJF_1997_AttenRelCoefficients coeff17 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.32"), 0.32, 0.518, 0.725, 0.619, 0.783, -0.152, -0.888, -0.42, 2104, 5.72, 0.442, 0.279, 0.523, 0.055, 0.525);
        BJF_1997_AttenRelCoefficients coeff18 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.34"), 0.34, 0.439, 0.648, 0.54, 0.794, -0.143, -0.882, -0.438, 2070, 5.5, 0.444, 0.281, 0.526, 0.064, 0.53);
        BJF_1997_AttenRelCoefficients coeff19 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.36"), 0.36, 0.361, 0.57, 0.462, 0.806, -0.136, -0.877, -0.456, 2032, 5.3, 0.444, 0.283, 0.527, 0.071, 0.532);
        BJF_1997_AttenRelCoefficients coeff20 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.38"), 0.38, 0.286, 0.495, 0.385, 0.82, -0.127, -0.872, -0.472, 1995, 5.1, 0.447, 0.286, 0.53, 0.078, 0.536);
        BJF_1997_AttenRelCoefficients coeff21 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.40"), 0.4, 0.212, 0.423, 0.311, 0.831, -0.12, -0.867, -0.487, 1954, 4.91, 0.447, 0.288, 0.531, 0.085, 0.538);
        BJF_1997_AttenRelCoefficients coeff22 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.42"), 0.42, 0.14, 0.352, 0.239, 0.84, -0.113, -0.862, -0.502, 1919, 4.74, 0.449, 0.29, 0.535, 0.092, 0.542);
        BJF_1997_AttenRelCoefficients coeff23 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.44"), 0.44, 0.073, 0.282, 0.169, 0.852, -0.108, -0.858, -0.516, 1884, 4.57, 0.449, 0.292, 0.536, 0.099, 0.545);
        BJF_1997_AttenRelCoefficients coeff24 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.46"), 0.46, 0.005, 0.217, 0.102, 0.863, -0.101, -0.854, -0.529, 1849, 4.41, 0.451, 0.295, 0.539, 0.104, 0.549);
        BJF_1997_AttenRelCoefficients coeff25 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.48"), 0.48, -0.058, 0.151, 0.036, 0.873, -0.097, -0.85, -0.541, 1816, 4.26, 0.451, 0.297, 0.54, 0.111, 0.551);
        BJF_1997_AttenRelCoefficients coeff26 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.50"), 0.5, -0.122, 0.087, -0.025, 0.884, -0.09, -0.846, -0.553, 1782, 4.13, 0.454, 0.299, 0.543, 0.115, 0.556);
        BJF_1997_AttenRelCoefficients coeff27 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.55"), 0.55, -0.268, -0.063, -0.176, 0.907, -0.078, -0.837, -0.579, 1710, 3.82, 0.456, 0.302, 0.547, 0.129, 0.562);
        BJF_1997_AttenRelCoefficients coeff28 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.60"), 0.6, -0.401, -0.203, -0.314, 0.928, -0.069, -0.83, -0.602, 1644, 3.57, 0.458, 0.306, 0.551, 0.143, 0.569);
        BJF_1997_AttenRelCoefficients coeff29 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.65"), 0.65, -0.523, -0.331, -0.44, 0.946, -0.06, -0.823, -0.622, 1592, 3.36, 0.461, 0.309, 0.554, 0.154, 0.575);
        BJF_1997_AttenRelCoefficients coeff30 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.70"), 0.7, -0.634, -0.452, -0.555, 0.962, -0.053, -0.818, -0.639, 1545, 3.2, 0.463, 0.311, 0.558, 0.166, 0.582);
        BJF_1997_AttenRelCoefficients coeff31 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.75"), 0.75, -0.737, -0.562, -0.661, 0.979, -0.046, -0.813, -0.653, 1507, 3.07, 0.465, 0.313, 0.561, 0.175, 0.587);
        BJF_1997_AttenRelCoefficients coeff32 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.80"), 0.8, -0.829, -0.666, -0.76, 0.992, -0.041, -0.809, -0.666, 1476, 2.98, 0.467, 0.315, 0.564, 0.184, 0.593);
        BJF_1997_AttenRelCoefficients coeff33 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.85"), 0.85, -0.915, -0.761, -0.851, 1.006, -0.037, -0.805, -0.676, 1452, 2.92, 0.467, 0.32, 0.567, 0.191, 0.598);
        BJF_1997_AttenRelCoefficients coeff34 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.90"), 0.9, -0.993, -0.848, -0.933, 1.018, -0.035, -0.802, -0.685, 1432, 2.89, 0.47, 0.322, 0.57, 0.2, 0.604);
        BJF_1997_AttenRelCoefficients coeff35 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("0.95"), 0.95, -1.066, -0.932, -1.01, 1.027, -0.032, -0.8, -0.692, 1416, 2.88, 0.472, 0.325, 0.573, 0.207, 0.609);
        BJF_1997_AttenRelCoefficients coeff36 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.00"), 1.0, -1.133, -1.009, -1.08, 1.036, -0.032, -0.798, -0.698, 1406, 2.9, 0.474, 0.325, 0.575, 0.214, 0.613);
        BJF_1997_AttenRelCoefficients coeff37 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.10"), 1.1, -1.249, -1.145, -1.208, 1.052, -0.03, -0.795, -0.706, 1396, 2.99, 0.477, 0.329, 0.579, 0.226, 0.622);
        BJF_1997_AttenRelCoefficients coeff38 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.20"), 1.2, -1.345, -1.265, -1.315, 1.064, -0.032, -0.794, -0.71, 1400, 3.14, 0.479, 0.334, 0.584, 0.235, 0.629);
        BJF_1997_AttenRelCoefficients coeff39 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.30"), 1.3, -1.428, -1.37, -1.407, 1.073, -0.035, -0.793, -0.711, 1416, 3.36, 0.481, 0.338, 0.588, 0.244, 0.637);
        BJF_1997_AttenRelCoefficients coeff40 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.40"), 1.4, -1.495, -1.46, -1.483, 1.08, -0.039, -0.794, -0.709, 1442, 3.62, 0.484, 0.341, 0.592, 0.251, 0.643);
        BJF_1997_AttenRelCoefficients coeff41 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.50"), 1.5, -1.552, -1.538, -1.55, 1.085, -0.044, -0.796, -0.704, 1479, 3.92, 0.486, 0.345, 0.596, 0.256, 0.649);
        BJF_1997_AttenRelCoefficients coeff42 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.60"), 1.6, -1.598, -1.608, -1.605, 1.087, -0.051, -0.798, -0.697, 1524, 4.26, 0.488, 0.348, 0.599, 0.262, 0.654);
        BJF_1997_AttenRelCoefficients coeff43 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.70"), 1.7, -1.634, -1.668, -1.652, 1.089, -0.058, -0.801, -0.689, 1581, 4.62, 0.49, 0.352, 0.604, 0.267, 0.66);
        BJF_1997_AttenRelCoefficients coeff44 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.80"), 1.8, -1.663, -1.718, -1.689, 1.087, -0.067, -0.804, -0.679, 1644, 5.01, 0.493, 0.355, 0.607, 0.269, 0.664);
        BJF_1997_AttenRelCoefficients coeff45 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("1.90"), 1.9, -1.685, -1.763, -1.72, 1.087, -0.074, -0.808, -0.667, 1714, 5.42, 0.493, 0.359, 0.61, 0.274, 0.669);
        BJF_1997_AttenRelCoefficients coeff46 = new BJF_1997_AttenRelCoefficients("SA/" + new Double("2.00"), 2.0, -1.699, -1.801, -1.743, 1.085, -0.085, -0.812, -0.655, 1795, 5.85, 0.495, 0.362, 0.613, 0.276, 0.672);
        this.coefficients.put(coeff.getName(), coeff);
        this.coefficients.put(coeff0.getName(), coeff0);
        this.coefficients.put(coeff1.getName(), coeff1);
        this.coefficients.put(coeff2.getName(), coeff2);
        this.coefficients.put(coeff3.getName(), coeff3);
        this.coefficients.put(coeff4.getName(), coeff4);
        this.coefficients.put(coeff5.getName(), coeff5);
        this.coefficients.put(coeff6.getName(), coeff6);
        this.coefficients.put(coeff7.getName(), coeff7);
        this.coefficients.put(coeff8.getName(), coeff8);
        this.coefficients.put(coeff9.getName(), coeff9);
        this.coefficients.put(coeff10.getName(), coeff10);
        this.coefficients.put(coeff11.getName(), coeff11);
        this.coefficients.put(coeff12.getName(), coeff12);
        this.coefficients.put(coeff13.getName(), coeff13);
        this.coefficients.put(coeff14.getName(), coeff14);
        this.coefficients.put(coeff15.getName(), coeff15);
        this.coefficients.put(coeff16.getName(), coeff16);
        this.coefficients.put(coeff17.getName(), coeff17);
        this.coefficients.put(coeff18.getName(), coeff18);
        this.coefficients.put(coeff19.getName(), coeff19);
        this.coefficients.put(coeff20.getName(), coeff20);
        this.coefficients.put(coeff21.getName(), coeff21);
        this.coefficients.put(coeff22.getName(), coeff22);
        this.coefficients.put(coeff23.getName(), coeff23);
        this.coefficients.put(coeff24.getName(), coeff24);
        this.coefficients.put(coeff25.getName(), coeff25);
        this.coefficients.put(coeff26.getName(), coeff26);
        this.coefficients.put(coeff27.getName(), coeff27);
        this.coefficients.put(coeff28.getName(), coeff28);
        this.coefficients.put(coeff29.getName(), coeff29);
        this.coefficients.put(coeff30.getName(), coeff30);
        this.coefficients.put(coeff31.getName(), coeff31);
        this.coefficients.put(coeff32.getName(), coeff32);
        this.coefficients.put(coeff33.getName(), coeff33);
        this.coefficients.put(coeff34.getName(), coeff34);
        this.coefficients.put(coeff35.getName(), coeff35);
        this.coefficients.put(coeff36.getName(), coeff36);
        this.coefficients.put(coeff37.getName(), coeff37);
        this.coefficients.put(coeff38.getName(), coeff38);
        this.coefficients.put(coeff39.getName(), coeff39);
        this.coefficients.put(coeff40.getName(), coeff40);
        this.coefficients.put(coeff41.getName(), coeff41);
        this.coefficients.put(coeff42.getName(), coeff42);
        this.coefficients.put(coeff43.getName(), coeff43);
        this.coefficients.put(coeff44.getName(), coeff44);
        this.coefficients.put(coeff45.getName(), coeff45);
        this.coefficients.put(coeff46.getName(), coeff46);
    }

    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/documentation/modelsImplemented/attenRel/BJF_1997.html");
    }

    class BJF_1997_AttenRelCoefficients
    implements NamedObjectAPI {
        protected static final String C = "BJF_1997_AttenRelCoefficients";
        protected static final boolean D = false;
        private static final long serialVersionUID = 1234567890987654323L;
        protected String name;
        protected double period = -1.0;
        protected double b1all;
        protected double b1ss;
        protected double b1rv;
        protected double b2;
        protected double b3;
        protected double b5;
        protected double bv;
        protected int va;
        protected double h;
        protected double sigma1;
        protected double sigmaC;
        protected double sigmaR;
        protected double sigmaE;
        protected double sigmaLnY;

        public BJF_1997_AttenRelCoefficients(String name) {
            this.name = name;
        }

        public BJF_1997_AttenRelCoefficients(String name, double period, double b1ss, double b1rv, double b1all, double b2, double b3, double b5, double bv, int va, double h, double sigma1, double sigmaC, double sigmaR, double sigmaE, double sigmaLnY) {
            this.period = period;
            this.b1ss = b1ss;
            this.b1rv = b1rv;
            this.b1all = b1all;
            this.b2 = b2;
            this.b3 = b3;
            this.b5 = b5;
            this.bv = bv;
            this.va = va;
            this.h = h;
            this.name = name;
            this.sigma1 = sigma1;
            this.sigmaC = sigmaC;
            this.sigmaR = sigmaR;
            this.sigmaE = sigmaE;
            this.sigmaLnY = sigmaLnY;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(C);
            b.append("\n  Period = " + this.period);
            b.append("\n  b1all = " + this.b1all);
            b.append("\n  b1ss = " + this.b1ss);
            b.append("\n  b1rv = " + this.b1rv);
            b.append("\n  b2 = " + this.b2);
            b.append("\n  b3 = " + this.b3);
            b.append("\n  b5 = " + this.b5);
            b.append("\n  bv = " + this.bv);
            b.append("\n va = " + this.va);
            b.append("\n  h = " + this.h);
            b.append("\n  sigma1 = " + this.sigma1);
            b.append("\n  sigmaC = " + this.sigmaC);
            b.append("\n  sigmaR = " + this.sigmaR);
            b.append("\n  sigmaE = " + this.sigmaE);
            b.append("\n  sigmaLnY = " + this.sigmaLnY);
            return b.toString();
        }
    }
}

