/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.DoubleDiscreteConstraint;
import org.opensha.commons.param.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.PropagationEffect;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.param.EqkRuptureParams.DipParam;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.EqkRuptureParams.RupTopDepthParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGD_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistRupMinusJB_OverRupParameter;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CB_2008_AttenRel
extends AttenuationRelationship
implements ScalarIntensityMeasureRelationshipAPI,
NamedObjectAPI,
ParameterChangeListener {
    private static final String C = "CB_2006_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "CB2008";
    private static final long serialVersionUID = 1234567890987654358L;
    public static final String NAME = "Campbell & Bozorgnia (2008)";
    private static final String CB_2008_CoeffFile = "campbell_2008_coeff.txt";
    double[] per;
    double[] c0;
    double[] c1;
    double[] c2;
    double[] c3;
    double[] c4;
    double[] c5;
    double[] c6;
    double[] c7;
    double[] c8;
    double[] c9;
    double[] c10;
    double[] c11;
    double[] c12;
    double[] k1;
    double[] k2;
    double[] k3;
    double[] s_lny;
    double[] t_lny;
    double[] s_c;
    double[] rho;
    double s_lnAF = 0.3;
    double n = 1.18;
    double c = 1.88;
    private HashMap indexFromPerHashMap;
    private int iper;
    private double vs30;
    private double rJB;
    private double rRup;
    private double distRupMinusJB_OverRup;
    private double f_rv;
    private double f_nm;
    private double mag;
    private double depthTop;
    private double depthTo2pt5kmPerSec;
    private double dip;
    private String stdDevType;
    private String component;
    private boolean magSaturation;
    private boolean parameterChange;
    private PropagationEffect propagationEffect;
    protected static final Double MAG_WARN_MIN = new Double(4.0);
    protected static final Double MAG_WARN_MAX = new Double(8.5);
    protected static final Double DISTANCE_RUP_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_RUP_WARN_MAX = new Double(200.0);
    protected static final Double DISTANCE_MINUS_WARN_MIN = new Double(0.0);
    protected static final Double DISTANCE_MINUS_WARN_MAX = new Double(50.0);
    protected static final Double VS30_WARN_MIN = new Double(150.0);
    protected static final Double VS30_WARN_MAX = new Double(1500.0);
    protected static final Double DEPTH_2pt5_WARN_MIN = new Double(0.0);
    protected static final Double DEPTH_2pt5_WARN_MAX = new Double(10.0);
    protected static final Double DIP_WARN_MIN = new Double(15.0);
    protected static final Double DIP_WARN_MAX = new Double(90.0);
    protected static final Double RUP_TOP_WARN_MIN = new Double(0.0);
    protected static final Double RUP_TOP_WARN_MAX = new Double(15.0);
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_NORMAL = "Normal";
    private transient ParameterChangeWarningListener warningListener = null;

    public CB_2008_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.readCoeffFile();
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 3; i < this.per.length; ++i) {
            this.indexFromPerHashMap.put(new Double(this.per[i]), new Integer(i));
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.propagationEffect = new PropagationEffect();
        this.propagationEffect.fixDistanceJB(true);
    }

    private void readCoeffFile() {
        try {
            ArrayList<String> coeff = FileUtils.loadFile(this.getClass().getResource(CB_2008_CoeffFile));
            String perLine = coeff.get(0);
            ArrayList<Double> period = new ArrayList<Double>();
            StringTokenizer st = new StringTokenizer(perLine);
            int size = this.loadCoeffInArray(st, period);
            this.per = new double[size];
            this.createCoeffArray(period, this.per);
            period = null;
            String c0Line = coeff.get(1);
            ArrayList<Double> c0List = new ArrayList<Double>();
            st = new StringTokenizer(c0Line);
            size = this.loadCoeffInArray(st, c0List);
            this.c0 = new double[size];
            this.createCoeffArray(c0List, this.c0);
            c0List = null;
            String c1Line = coeff.get(2);
            ArrayList<Double> c1List = new ArrayList<Double>();
            st = new StringTokenizer(c1Line);
            size = this.loadCoeffInArray(st, c1List);
            this.c1 = new double[size];
            this.createCoeffArray(c1List, this.c1);
            c1List = null;
            String c2Line = coeff.get(3);
            ArrayList<Double> c2List = new ArrayList<Double>();
            st = new StringTokenizer(c2Line);
            size = this.loadCoeffInArray(st, c2List);
            this.c2 = new double[size];
            this.createCoeffArray(c2List, this.c2);
            c2List = null;
            String c3Line = coeff.get(4);
            ArrayList<Double> c3List = new ArrayList<Double>();
            st = new StringTokenizer(c3Line);
            size = this.loadCoeffInArray(st, c3List);
            this.c3 = new double[size];
            this.createCoeffArray(c3List, this.c3);
            c3List = null;
            String c4Line = coeff.get(5);
            ArrayList<Double> c4List = new ArrayList<Double>();
            st = new StringTokenizer(c4Line);
            size = this.loadCoeffInArray(st, c4List);
            this.c4 = new double[size];
            this.createCoeffArray(c4List, this.c4);
            c4List = null;
            String c5Line = coeff.get(6);
            ArrayList<Double> c5List = new ArrayList<Double>();
            st = new StringTokenizer(c5Line);
            size = this.loadCoeffInArray(st, c5List);
            this.c5 = new double[size];
            this.createCoeffArray(c5List, this.c5);
            c5List = null;
            String c6Line = coeff.get(7);
            ArrayList<Double> c6List = new ArrayList<Double>();
            st = new StringTokenizer(c6Line);
            size = this.loadCoeffInArray(st, c6List);
            this.c6 = new double[size];
            this.createCoeffArray(c6List, this.c6);
            c6List = null;
            String c7Line = coeff.get(8);
            ArrayList<Double> c7List = new ArrayList<Double>();
            st = new StringTokenizer(c7Line);
            size = this.loadCoeffInArray(st, c7List);
            this.c7 = new double[size];
            this.createCoeffArray(c7List, this.c7);
            c7List = null;
            String c8Line = coeff.get(9);
            ArrayList<Double> c8List = new ArrayList<Double>();
            st = new StringTokenizer(c8Line);
            size = this.loadCoeffInArray(st, c8List);
            this.c8 = new double[size];
            this.createCoeffArray(c8List, this.c8);
            c8List = null;
            String c9Line = coeff.get(10);
            ArrayList<Double> c9List = new ArrayList<Double>();
            st = new StringTokenizer(c9Line);
            size = this.loadCoeffInArray(st, c9List);
            this.c9 = new double[size];
            this.createCoeffArray(c9List, this.c9);
            c9List = null;
            String c10Line = coeff.get(11);
            ArrayList<Double> c10List = new ArrayList<Double>();
            st = new StringTokenizer(c10Line);
            size = this.loadCoeffInArray(st, c10List);
            this.c10 = new double[size];
            this.createCoeffArray(c10List, this.c10);
            c10List = null;
            String c11Line = coeff.get(12);
            ArrayList<Double> c11List = new ArrayList<Double>();
            st = new StringTokenizer(c11Line);
            size = this.loadCoeffInArray(st, c11List);
            this.c11 = new double[size];
            this.createCoeffArray(c11List, this.c11);
            c11List = null;
            String c12Line = coeff.get(13);
            ArrayList<Double> c12List = new ArrayList<Double>();
            st = new StringTokenizer(c12Line);
            size = this.loadCoeffInArray(st, c12List);
            this.c12 = new double[size];
            this.createCoeffArray(c12List, this.c12);
            c12List = null;
            String k1Line = coeff.get(14);
            ArrayList<Double> k1List = new ArrayList<Double>();
            st = new StringTokenizer(k1Line);
            size = this.loadCoeffInArray(st, k1List);
            this.k1 = new double[size];
            this.createCoeffArray(k1List, this.k1);
            k1List = null;
            String k2Line = coeff.get(15);
            ArrayList<Double> k2List = new ArrayList<Double>();
            st = new StringTokenizer(k2Line);
            size = this.loadCoeffInArray(st, k2List);
            this.k2 = new double[size];
            this.createCoeffArray(k2List, this.k2);
            k2List = null;
            String k3Line = coeff.get(16);
            ArrayList<Double> k3List = new ArrayList<Double>();
            st = new StringTokenizer(k3Line);
            size = this.loadCoeffInArray(st, k3List);
            this.k3 = new double[size];
            this.createCoeffArray(k3List, this.k3);
            k3List = null;
            String s_lnyLine = coeff.get(17);
            ArrayList<Double> s_lnyList = new ArrayList<Double>();
            st = new StringTokenizer(s_lnyLine);
            size = this.loadCoeffInArray(st, s_lnyList);
            this.s_lny = new double[size];
            this.createCoeffArray(s_lnyList, this.s_lny);
            s_lnyList = null;
            String t_lnyLine = coeff.get(18);
            ArrayList<Double> t_lnyList = new ArrayList<Double>();
            st = new StringTokenizer(t_lnyLine);
            size = this.loadCoeffInArray(st, t_lnyList);
            this.t_lny = new double[size];
            this.createCoeffArray(t_lnyList, this.t_lny);
            t_lnyList = null;
            String c_lnyLine = coeff.get(19);
            ArrayList<Double> c_lnyList = new ArrayList<Double>();
            st = new StringTokenizer(c_lnyLine);
            size = this.loadCoeffInArray(st, c_lnyList);
            this.s_c = new double[size];
            this.createCoeffArray(c_lnyList, this.s_c);
            c_lnyList = null;
            String rho_sLine = coeff.get(20);
            ArrayList<Double> rho_sList = new ArrayList<Double>();
            st = new StringTokenizer(rho_sLine);
            size = this.loadCoeffInArray(st, rho_sList);
            this.rho = new double[size];
            this.createCoeffArray(rho_sList, this.rho);
            rho_sList = null;
        }
        catch (Exception e) {
            throw new RuntimeException("campbell_2008_coeff.txt file Not Found", e);
        }
    }

    private int loadCoeffInArray(StringTokenizer st, ArrayList<Double> coeff) {
        st.nextToken();
        while (st.hasMoreTokens()) {
            coeff.add(Double.parseDouble(st.nextToken().trim()));
        }
        return coeff.size();
    }

    private void createCoeffArray(ArrayList<Double> coeff, double[] c) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = coeff.get(i);
        }
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(new Double(eqkRupture.getMag()));
        double rake = eqkRupture.getAveRake();
        if (rake > 30.0 && rake < 150.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else if (rake > -150.0 && rake < -30.0) {
            this.fltTypeParam.setValue(FLT_TYPE_NORMAL);
        } else {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        }
        EvenlyGriddedSurfaceAPI surface = eqkRupture.getRuptureSurface();
        double depth = surface.getLocation(0, 0).getDepth();
        this.rupTopDepthParam.setValue(depth);
        this.dipParam.setValueIgnoreWarning(surface.getAveDip());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValue((Double)site.getParameter("Vs30").getValue());
        this.depthTo2pt5kmPerSecParam.setValueIgnoreWarning((Double)site.getParameter("Depth 2.5 km/sec").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.propagationEffect.setAll(this.eqkRupture, this.site);
            this.distanceRupParam.setValueIgnoreWarning(this.propagationEffect.getParamValue("DistanceRup"));
            double dist_jb = (Double)this.propagationEffect.getParamValue("DistanceJB");
            if (this.rRup == 0.0) {
                this.distRupMinusJB_OverRupParam.setValueIgnoreWarning((Object)0.0);
            } else {
                this.distRupMinusJB_OverRupParam.setValueIgnoreWarning((Object)((this.rRup - dist_jb) / this.rRup));
            }
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("CB_2006_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        if (this.im.getName().equalsIgnoreCase("SA")) {
            this.iper = (Integer)this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        } else if (this.im.getName().equalsIgnoreCase("PGV")) {
            this.iper = 1;
        } else if (this.im.getName().equalsIgnoreCase("PGA")) {
            this.iper = 2;
        } else if (this.im.getName().equalsIgnoreCase("PGD")) {
            this.iper = 0;
        }
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        this.rJB = this.rRup - this.distRupMinusJB_OverRup * this.rRup;
        if (Double.isNaN(this.depthTo2pt5kmPerSec)) {
            this.depthTo2pt5kmPerSec = this.vs30 <= 2500.0 ? 2.0 : 0.0;
        }
        double pga_rock = Math.exp(this.getMean(2, 1100.0, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.dip, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, 0.0));
        double mean = this.getMean(this.iper, this.vs30, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.dip, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, pga_rock);
        if (this.iper < 3 || this.iper > 11) {
            return mean;
        }
        double pga_mean = this.getMean(2, this.vs30, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.dip, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, pga_rock);
        return Math.max(mean, pga_mean);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        this.rJB = this.rRup - this.distRupMinusJB_OverRup * this.rRup;
        if (Double.isNaN(this.depthTo2pt5kmPerSec)) {
            this.depthTo2pt5kmPerSec = this.vs30 <= 2500.0 ? 2.0 : 0.0;
        }
        double pga_rock = Double.NaN;
        if (this.vs30 < this.k1[this.iper]) {
            pga_rock = Math.exp(this.getMean(2, 1100.0, this.rRup, this.rJB, this.f_rv, this.f_nm, this.mag, this.dip, this.depthTop, this.depthTo2pt5kmPerSec, this.magSaturation, 0.0));
        }
        this.component = (String)this.componentParam.getValue();
        double stdDev = this.getStdDev(this.iper, this.stdDevType, this.component, this.vs30, pga_rock);
        return stdDev;
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.rupTopDepthParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.distRupMinusJB_OverRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.pgvParam.setValueAsDefault();
        this.pgdParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.depthTo2pt5kmPerSecParam.setValueAsDefault();
        this.dipParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.distRupMinusJB_OverRupParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.depthTo2pt5kmPerSecParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.rupTopDepthParam);
        this.meanIndependentParams.addParameter(this.dipParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameterList(this.meanIndependentParams);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.stdDevIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.depthTo2pt5kmPerSecParam = new DepthTo2pt5kmPerSecParam(DEPTH_2pt5_WARN_MIN, (double)DEPTH_2pt5_WARN_MAX);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.dipParam = new DipParam(DIP_WARN_MIN, (double)DIP_WARN_MAX);
        this.rupTopDepthParam = new RupTopDepthParam(RUP_TOP_WARN_MIN, (double)RUP_TOP_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_NORMAL);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_STRIKE_SLIP);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
        this.eqkRuptureParams.addParameter(this.dipParam);
        this.eqkRuptureParams.addParameter(this.rupTopDepthParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        this.distanceRupParam.setNonEditable();
        this.distRupMinusJB_OverRupParam = new DistRupMinusJB_OverRupParameter(0.0);
        DoubleConstraint warnJB = new DoubleConstraint(DISTANCE_MINUS_WARN_MIN, DISTANCE_MINUS_WARN_MAX);
        this.distRupMinusJB_OverRupParam.addParameterChangeWarningListener(this.warningListener);
        warn.setNonEditable();
        this.distRupMinusJB_OverRupParam.setWarningConstraint(warnJB);
        this.distRupMinusJB_OverRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
        this.propagationEffectParams.addParameter(this.distRupMinusJB_OverRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 3; i < this.per.length; ++i) {
            periodConstraint.addDouble(new Double(this.per[i]));
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.pgdParam = new PGD_Param();
        this.pgdParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.pgvParam.addParameterChangeWarningListener(this.warningListener);
        this.pgdParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
        this.supportedIMParams.addParameter(this.pgdParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal (GMRotI50)");
        constraint.addString("Random Horizontal");
        this.componentParam = new ComponentParam(constraint, "Average Horizontal (GMRotI50)");
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int iper, double vs30, double rRup, double distJB, double f_rv, double f_nm, double mag, double dip, double depthTop, double depthTo2pt5kmPerSec, boolean magSaturation, double pga_rock) {
        double fmag = mag <= 5.5 ? this.c0[iper] + this.c1[iper] * mag : (mag > 5.5 && mag <= 6.5 ? this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) : this.c0[iper] + this.c1[iper] * mag + this.c2[iper] * (mag - 5.5) + this.c3[iper] * (mag - 6.5));
        double fdis = (this.c4[iper] + this.c5[iper] * mag) * Math.log(Math.sqrt(rRup * rRup + this.c6[iper] * this.c6[iper]));
        double ffltz = depthTop < 1.0 ? depthTop : 1.0;
        double fflt = this.c7[iper] * f_rv * ffltz + this.c8[iper] * f_nm;
        double fhngr = distJB == 0.0 ? 1.0 : (depthTop < 1.0 && distJB > 0.0 ? (Math.max(rRup, Math.sqrt(distJB * distJB + 1.0)) - distJB) / Math.max(rRup, Math.sqrt(distJB * distJB + 1.0)) : (rRup - distJB) / rRup);
        double fhngm = mag <= 6.0 ? 0.0 : (mag > 6.0 && mag < 6.5 ? 2.0 * (mag - 6.0) : 1.0);
        double fhngz = depthTop >= 20.0 ? 0.0 : (20.0 - depthTop) / 20.0;
        double fhngd = dip <= 70.0 ? 1.0 : (90.0 - dip) / 20.0;
        double fhng = this.c9[iper] * fhngr * fhngm * fhngz * fhngd;
        double fsite = vs30 < this.k1[iper] ? this.c10[iper] * Math.log(vs30 / this.k1[iper]) + this.k2[iper] * (Math.log(pga_rock + this.c * Math.pow(vs30 / this.k1[iper], this.n)) - Math.log(pga_rock + this.c)) : (vs30 < 1100.0 ? (this.c10[iper] + this.k2[iper] * this.n) * Math.log(vs30 / this.k1[iper]) : (this.c10[iper] + this.k2[iper] * this.n) * Math.log(1100.0 / this.k1[iper]));
        double fsed = depthTo2pt5kmPerSec < 1.0 ? this.c11[iper] * (depthTo2pt5kmPerSec - 1.0) : (depthTo2pt5kmPerSec <= 3.0 ? 0.0 : this.c12[iper] * this.k3[iper] * Math.exp(-0.75) * (1.0 - Math.exp(-0.25 * (depthTo2pt5kmPerSec - 3.0))));
        return fmag + fdis + fflt + fhng + fsite + fsed;
    }

    public double getStdDev(int iper, String stdDevType, String component, double vs30, double rock_pga) {
        double sigma;
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        double tau = this.t_lny[iper];
        if (vs30 >= this.k1[iper]) {
            sigma = this.s_lny[iper];
        } else {
            double s_lnYb = Math.sqrt(this.s_lny[iper] * this.s_lny[iper] - this.s_lnAF * this.s_lnAF);
            double s_lnAb = Math.sqrt(this.s_lny[2] * this.s_lny[2] - this.s_lnAF * this.s_lnAF);
            double alpha = this.k2[iper] * rock_pga * (1.0 / (rock_pga + this.c * Math.pow(vs30 / this.k1[iper], this.n)) - 1.0 / (rock_pga + this.c));
            sigma = Math.sqrt(s_lnYb * s_lnYb + this.s_lnAF * this.s_lnAF + alpha * alpha * s_lnAb * s_lnAb + 2.0 * alpha * this.rho[iper] * s_lnYb * s_lnAb);
        }
        double sigma_total = Math.sqrt(tau * tau + sigma * sigma);
        double random_ratio = component.equals("Random Horizontal") ? Math.sqrt(1.0 + this.s_c[iper] * this.s_c[iper] / (sigma_total * sigma_total)) : 1.0;
        if (stdDevType.equals("Total")) {
            return sigma_total * random_ratio;
        }
        if (stdDevType.equals("Intra-Event")) {
            return sigma * random_ratio;
        }
        if (stdDevType.equals("Inter-Event")) {
            return tau * random_ratio;
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("(distRup-distJB)/distRup")) {
            this.distRupMinusJB_OverRup = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("Depth 2.5 km/sec")) {
            this.depthTo2pt5kmPerSec = val == null ? Double.NaN : (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Fault Type")) {
            String fltType = (String)this.fltTypeParam.getValue();
            if (fltType.equals(FLT_TYPE_NORMAL)) {
                this.f_rv = 0.0;
                this.f_nm = 1.0;
            } else if (fltType.equals(FLT_TYPE_REVERSE)) {
                this.f_rv = 1.0;
                this.f_nm = 0.0;
            } else {
                this.f_rv = 0.0;
                this.f_nm = 0.0;
            }
        } else if (pName.equals("Rupture Top Depth")) {
            this.depthTop = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("Dip")) {
            this.dip = (Double)val;
        } else if (pName.equals("Component")) {
            this.component = (String)this.componentParam.getValue();
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.fltTypeParam.removeParameterChangeListener(this);
        this.rupTopDepthParam.removeParameterChangeListener(this);
        this.dipParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.distRupMinusJB_OverRupParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.depthTo2pt5kmPerSecParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.rupTopDepthParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
        this.dipParam.addParameterChangeListener(this);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/documentation/modelsImplemented/attenRel/CB_2008.html");
    }

    public static void main(String[] args) {
        Location loc1 = new Location(-0.1, 0.0, 0.0);
        Location loc2 = new Location(0.1, 0.0, 0.0);
        FaultTrace faultTrace = new FaultTrace("test");
        faultTrace.addLocation(loc1);
        faultTrace.addLocation(loc2);
        StirlingGriddedSurface surface = new StirlingGriddedSurface(faultTrace, 45.0, 0.0, 10.0, 1.0);
        EqkRupture rup = new EqkRupture();
        rup.setMag(7.0);
        rup.setAveRake(90.0);
        rup.setRuptureSurface(surface);
        CB_2008_AttenRel attenRel = new CB_2008_AttenRel(null);
        attenRel.setParamDefaults();
        attenRel.setIntensityMeasure("PGA");
        attenRel.setEqkRupture(rup);
        Site site = new Site();
        site.addParameter(attenRel.getParameter("Vs30"));
        site.addParameter(attenRel.getParameter("Depth 2.5 km/sec"));
        for (double dist = -0.3; dist <= 0.3; dist += 0.01) {
            Location loc = new Location(0.0, dist);
            site.setLocation(loc);
            attenRel.setSite(site);
            attenRel.getMean();
        }
    }
}

