/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.ListIterator;
import org.opensha.commons.calc.GaussianDistCalc;
import org.opensha.commons.data.DataPoint2D;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.NamedObjectAPI;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFuncAPI;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.DoubleDiscreteConstraint;
import org.opensha.commons.param.DoubleParameter;
import org.opensha.commons.param.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.PropagationEffect;
import org.opensha.sha.imr.ScalarIntensityMeasureRelationshipAPI;
import org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SadighEtAl_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.calc.Borcherdt2004_SiteAmpCalc;
import org.opensha.sha.imr.attenRelImpl.calc.Wald_MMI_Calc;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class USGS_Combined_2004_AttenRel
extends AttenuationRelationship
implements ScalarIntensityMeasureRelationshipAPI,
NamedObjectAPI {
    private static final String C = "USGS_Combined_2004_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "USGS Combined (2004)";
    public static final String SHORT_NAME = "USGS_2004";
    private static final long serialVersionUID = 1234567890987654370L;
    private final AS_1997_AttenRel as_1997_attenRel;
    private final CB_2003_AttenRel cb_2003_attenRel;
    private final SadighEtAl_1997_AttenRel scemy_1997_attenRel;
    private final BJF_1997_AttenRel bjf_1997_attenRel;
    private double vs30;
    private static final double VS30_REF = 760.0;
    private double SA10toPGV = Math.log(94.62484798372687);
    Borcherdt2004_SiteAmpCalc borcherdtAmpCalc = new Borcherdt2004_SiteAmpCalc();
    private Site site_BC;
    protected static final Double VS30_WARN_MIN = new Double(180.0);
    protected static final Double VS30_WARN_MAX = new Double(3500.0);
    public static final String COMPONENT_GREATER_OF_TWO_HORZ = "Greater of Two Horz.";
    protected DoubleParameter mmiParam = null;
    public static final String MMI_NAME = "MMI";
    protected static final Double MMI_DEFAULT = new Double(Math.log(5.0));
    public static final String MMI_INFO = "Modified Mercalli Intensity";
    protected static final Double MMI_MIN = new Double(Math.log(1.0));
    protected static final Double MMI_MAX = new Double(Math.log(10.0));
    public static final String MMI_ERROR_STRING = "Problem: USGS Combined (2004) cannot complete\n the requested computation for MMI.\n\nThis has occurred because you attempted to compute the\nstandard deviation (or something else such as probability \nof exceedance which depends on the standard deviation).  \nThe inability to compute these will remain until someone comes up\nwith the probability distribution for MMI (when computed from\nPGA or PGV).  For now you can compute the median or the\nIML that has exactly a 0.5 chance of being exceeded (assuming\nthis application supports such computations).\n";
    public static final String UNSUPPORTED_METHOD_ERROR = "This method is not supprted";
    private transient ParameterChangeWarningListener warningListener = null;

    public USGS_Combined_2004_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.as_1997_attenRel = new AS_1997_AttenRel(warningListener);
        this.cb_2003_attenRel = new CB_2003_AttenRel(warningListener);
        this.scemy_1997_attenRel = new SadighEtAl_1997_AttenRel(warningListener);
        this.bjf_1997_attenRel = new BJF_1997_AttenRel(warningListener);
        this.site_BC = new Site();
        this.propEffect = new PropagationEffect();
        this.as_1997_attenRel.getParameter("AS Site Type").setValue("Rock/Shallow-Soil");
        this.site_BC.addParameter(this.as_1997_attenRel.getParameter("AS Site Type"));
        this.cb_2003_attenRel.getParameter("Campbell-2003 Site Type").setValue("BC-Boundary");
        this.site_BC.addParameter(this.cb_2003_attenRel.getParameter("Campbell-2003 Site Type"));
        this.scemy_1997_attenRel.getParameter("Sadigh Site Type").setValue("Rock");
        this.site_BC.addParameter(this.scemy_1997_attenRel.getParameter("Sadigh Site Type"));
        this.bjf_1997_attenRel.getParameter("Vs30").setValue(new Double(760.0));
        this.site_BC.addParameter(this.bjf_1997_attenRel.getParameter("Vs30"));
        this.as_1997_attenRel.getParameter("Component").setValue("Average Horizontal");
        this.cb_2003_attenRel.getParameter("Component").setValue("Average Horizontal");
        this.scemy_1997_attenRel.getParameter("Component").setValue("Average Horizontal");
        this.bjf_1997_attenRel.getParameter("Component").setValue("Random Horizontal");
    }

    public void setPropagationEffect(PropagationEffect propEffect) throws ParameterException {
        this.site = propEffect.getSite();
        this.eqkRupture = propEffect.getEqkRupture();
        this.propEffect.setEqkRupture(this.eqkRupture);
        this.vs30Param.setValueIgnoreWarning((Double)this.site.getParameter("Vs30").getValue());
        this.site_BC.setLocation(this.site.getLocation());
        this.propEffect.setSite(this.site_BC);
        this.as_1997_attenRel.setPropagationEffect(this.propEffect);
        this.bjf_1997_attenRel.setPropagationEffect(this.propEffect);
        this.scemy_1997_attenRel.setPropagationEffect(this.propEffect);
        this.cb_2003_attenRel.setPropagationEffect(this.propEffect);
    }

    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
        this.propEffect.setEqkRupture(eqkRupture);
        if (this.propEffect.getSite() != null) {
            this.as_1997_attenRel.setPropagationEffect(this.propEffect);
            this.bjf_1997_attenRel.setPropagationEffect(this.propEffect);
            this.scemy_1997_attenRel.setPropagationEffect(this.propEffect);
            this.cb_2003_attenRel.setPropagationEffect(this.propEffect);
        }
    }

    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.site = site;
        this.site_BC.setLocation(site.getLocation());
        this.propEffect.setSite(this.site_BC);
        if (this.eqkRupture != null) {
            this.as_1997_attenRel.setPropagationEffect(this.propEffect);
            this.bjf_1997_attenRel.setPropagationEffect(this.propEffect);
            this.scemy_1997_attenRel.setPropagationEffect(this.propEffect);
            this.cb_2003_attenRel.setPropagationEffect(this.propEffect);
        }
    }

    public void setSiteLocation(Location loc) {
        if (this.site == null) {
            this.site = new Site();
        }
        this.site.setLocation(loc);
        this.site_BC.setLocation(loc);
        this.propEffect.setSite(this.site_BC);
        if (this.eqkRupture != null) {
            this.as_1997_attenRel.setPropagationEffect(this.propEffect);
            this.bjf_1997_attenRel.setPropagationEffect(this.propEffect);
            this.scemy_1997_attenRel.setPropagationEffect(this.propEffect);
            this.cb_2003_attenRel.setPropagationEffect(this.propEffect);
        }
    }

    public double getMean() throws IMRException {
        this.vs30 = (Double)this.vs30Param.getValue();
        this.setAttenRelsIMT();
        String imt = this.im.getName();
        double per = (Double)this.saPeriodParam.getValue();
        double mean = 0.0;
        if (imt.equals("SA") && per >= 3.0) {
            mean += this.getMean(this.as_1997_attenRel);
            mean += this.getMean(this.cb_2003_attenRel);
            return (mean += this.getMean(this.scemy_1997_attenRel)) / 3.0;
        }
        mean += this.getMean(this.as_1997_attenRel);
        mean += this.getMean(this.cb_2003_attenRel);
        mean += this.getMean(this.bjf_1997_attenRel);
        return (mean += this.getMean(this.scemy_1997_attenRel)) / 4.0;
    }

    private double getExceedProbability(AttenuationRelationship attenRel, double iml) {
        double mean = this.getMean(attenRel);
        double stdDev = attenRel.getStdDev();
        return this.getExceedProbability(mean, stdDev, iml);
    }

    private double getEpsilon(AttenuationRelationship attenRel, double iml) {
        double mean = this.getMean(attenRel);
        double stdDev = attenRel.getStdDev();
        return (iml - mean) / stdDev;
    }

    private double getMean(AttenuationRelationship attenRel) {
        double mean;
        String imt = this.im.getName();
        if (imt.equals("PGA")) {
            double pga_bc = attenRel.getMean();
            double amp = this.borcherdtAmpCalc.getShortPeriodAmp(this.vs30, 760.0, Math.exp(pga_bc));
            mean = pga_bc + Math.log(amp);
        } else if (imt.equals("SA")) {
            double ave_bc = attenRel.getMean();
            attenRel.setIntensityMeasure("PGA");
            double pga_bc = attenRel.getMean();
            attenRel.setIntensityMeasure("SA");
            double per = (Double)this.saPeriodParam.getValue();
            double amp = per <= 0.5 ? this.borcherdtAmpCalc.getShortPeriodAmp(this.vs30, 760.0, Math.exp(pga_bc)) : this.borcherdtAmpCalc.getMidPeriodAmp(this.vs30, 760.0, Math.exp(pga_bc));
            mean = ave_bc + Math.log(amp);
        } else if (imt.equals("PGV")) {
            double ave_bc = attenRel.getMean();
            attenRel.setIntensityMeasure("PGA");
            double pga_bc = attenRel.getMean();
            attenRel.setIntensityMeasure("SA");
            double amp = this.borcherdtAmpCalc.getMidPeriodAmp(this.vs30, 760.0, Math.exp(pga_bc));
            mean = ave_bc + Math.log(amp) + this.SA10toPGV;
        } else {
            attenRel.setIntensityMeasure("SA");
            attenRel.getParameter("SA Period").setValue(new Double(1.0));
            double ave_bc = attenRel.getMean();
            attenRel.setIntensityMeasure("PGA");
            double pga_bc = attenRel.getMean();
            double amp = this.borcherdtAmpCalc.getMidPeriodAmp(this.vs30, 760.0, pga_bc);
            double pgv = ave_bc + Math.log(amp) + Math.log(94.6658);
            amp = this.borcherdtAmpCalc.getShortPeriodAmp(this.vs30, 760.0, Math.exp(pga_bc));
            double pga = pga_bc + Math.log(amp);
            double mmi = Wald_MMI_Calc.getMMI(Math.exp(pga), Math.exp(pgv));
            mean = Math.log(mmi);
        }
        String comp = (String)this.componentParam.getValue();
        if (comp.equals(COMPONENT_GREATER_OF_TWO_HORZ)) {
            mean += 0.139762;
        }
        return mean;
    }

    private void setAttenRelsIMT() {
        String imt = this.im.getName();
        if (imt.equals("PGA")) {
            this.as_1997_attenRel.setIntensityMeasure("PGA");
            this.scemy_1997_attenRel.setIntensityMeasure("PGA");
            this.cb_2003_attenRel.setIntensityMeasure("PGA");
            this.bjf_1997_attenRel.setIntensityMeasure("PGA");
        } else if (imt.equals("SA")) {
            Double per = (Double)this.saPeriodParam.getValue();
            this.as_1997_attenRel.setIntensityMeasure("SA");
            this.as_1997_attenRel.getParameter("SA Period").setValue(per);
            this.scemy_1997_attenRel.setIntensityMeasure("SA");
            this.scemy_1997_attenRel.getParameter("SA Period").setValue(per);
            this.cb_2003_attenRel.setIntensityMeasure("SA");
            this.cb_2003_attenRel.getParameter("SA Period").setValue(per);
            if (per <= 2.0) {
                this.bjf_1997_attenRel.setIntensityMeasure("SA");
                this.bjf_1997_attenRel.getParameter("SA Period").setValue(per);
            }
        } else if (imt.equals("PGV")) {
            Double per = new Double(1.0);
            this.as_1997_attenRel.setIntensityMeasure("SA");
            this.as_1997_attenRel.getParameter("SA Period").setValue(per);
            this.scemy_1997_attenRel.setIntensityMeasure("SA");
            this.scemy_1997_attenRel.getParameter("SA Period").setValue(per);
            this.cb_2003_attenRel.setIntensityMeasure("SA");
            this.cb_2003_attenRel.getParameter("SA Period").setValue(per);
            if (per <= 2.0) {
                this.bjf_1997_attenRel.setIntensityMeasure("SA");
                this.bjf_1997_attenRel.getParameter("SA Period").setValue(per);
            }
        }
    }

    private void setAttenRelsStdDevTypes() {
        String stdTyp = (String)this.stdDevTypeParam.getValue();
        this.as_1997_attenRel.getParameter("Std Dev Type").setValue(stdTyp);
        this.scemy_1997_attenRel.getParameter("Std Dev Type").setValue(stdTyp);
        this.bjf_1997_attenRel.getParameter("Std Dev Type").setValue(stdTyp);
        if (stdTyp.equals("Total")) {
            this.cb_2003_attenRel.getParameter("Std Dev Type").setValue("Total (Mag Dependent)");
        } else {
            this.cb_2003_attenRel.getParameter("Std Dev Type").setValue("None (zero)");
        }
    }

    public double getIML_AtExceedProb() throws ParameterException {
        double stRndVar;
        if (this.exceedProbParam == null || this.exceedProbParam.getValue() == null) {
            throw new ParameterException("USGS_Combined_2004_AttenRel: getIML_AtExceedProb(): exceedProbParam or its value is null, unable to run this calculation.");
        }
        double exceedProb = (Double)this.exceedProbParam.getValue();
        String sigTrType = (String)this.sigmaTruncTypeParam.getValue();
        if (!sigTrType.equals("1 Sided") && exceedProb == 0.5) {
            return this.getMean();
        }
        if (this.im.getName().equals(MMI_NAME)) {
            throw new RuntimeException(MMI_ERROR_STRING);
        }
        if (sigTrType.equals("None")) {
            stRndVar = GaussianDistCalc.getStandRandVar(exceedProb, 0, 0.0, 1.0E-6);
        } else {
            double numSig = (Double)this.sigmaTruncLevelParam.getValue();
            stRndVar = sigTrType.equals("1 Sided") ? GaussianDistCalc.getStandRandVar(exceedProb, 1, numSig, 1.0E-6) : GaussianDistCalc.getStandRandVar(exceedProb, 2, numSig, 1.0E-6);
        }
        double ave_iml = 0.0;
        this.vs30 = (Double)this.vs30Param.getValue();
        this.setAttenRelsStdDevTypes();
        this.setAttenRelsIMT();
        String imt = this.im.getName();
        double per = (Double)this.saPeriodParam.getValue();
        if (imt.equals("SA") && per >= 3.0) {
            ave_iml += this.getMean(this.as_1997_attenRel) + stRndVar * this.as_1997_attenRel.getStdDev();
            ave_iml += this.getMean(this.scemy_1997_attenRel) + stRndVar * this.scemy_1997_attenRel.getStdDev();
            return (ave_iml += this.getMean(this.cb_2003_attenRel) + stRndVar * this.cb_2003_attenRel.getStdDev()) / 3.0;
        }
        ave_iml += this.getMean(this.as_1997_attenRel) + stRndVar * this.as_1997_attenRel.getStdDev();
        ave_iml += this.getMean(this.scemy_1997_attenRel) + stRndVar * this.scemy_1997_attenRel.getStdDev();
        ave_iml += this.getMean(this.bjf_1997_attenRel) + stRndVar * this.bjf_1997_attenRel.getStdDev();
        return (ave_iml += this.getMean(this.cb_2003_attenRel) + stRndVar * this.cb_2003_attenRel.getStdDev()) / 4.0;
    }

    public double getStdDev() throws IMRException {
        if (((String)this.stdDevTypeParam.getValue()).equals("None (zero)")) {
            return 0.0;
        }
        this.vs30 = (Double)this.vs30Param.getValue();
        this.setAttenRelsIMT();
        this.setAttenRelsStdDevTypes();
        String imt = this.im.getName();
        double per = (Double)this.saPeriodParam.getValue();
        double std = 0.0;
        if (imt.equals("SA") && per >= 3.0) {
            std += this.as_1997_attenRel.getStdDev();
            std += this.cb_2003_attenRel.getStdDev();
            return (std += this.scemy_1997_attenRel.getStdDev()) / 3.0;
        }
        std += this.as_1997_attenRel.getStdDev();
        std += this.cb_2003_attenRel.getStdDev();
        std += this.bjf_1997_attenRel.getStdDev();
        return (std += this.scemy_1997_attenRel.getStdDev()) / 4.0;
    }

    private double getCombinedExceedProbability(double iml) throws ParameterException, IMRException {
        double per = (Double)this.saPeriodParam.getValue();
        double prob = 0.0;
        if (this.im.getName().equals("SA") && per >= 3.0) {
            prob += this.getExceedProbability(this.as_1997_attenRel, iml);
            prob += this.getExceedProbability(this.cb_2003_attenRel, iml);
            return (prob += this.getExceedProbability(this.scemy_1997_attenRel, iml)) / 3.0;
        }
        prob += this.getExceedProbability(this.as_1997_attenRel, iml);
        prob += this.getExceedProbability(this.cb_2003_attenRel, iml);
        prob += this.getExceedProbability(this.bjf_1997_attenRel, iml);
        return (prob += this.getExceedProbability(this.scemy_1997_attenRel, iml)) / 4.0;
    }

    private double getCombinedEpsilon(double iml) throws ParameterException, IMRException {
        double per = (Double)this.saPeriodParam.getValue();
        double wt = 0.0;
        double epsilon = 0.0;
        double prob = this.getExceedProbability(this.as_1997_attenRel, iml);
        epsilon += prob * this.getEpsilon(this.as_1997_attenRel, iml);
        wt += prob;
        prob = this.getExceedProbability(this.cb_2003_attenRel, iml);
        epsilon += prob * this.getEpsilon(this.cb_2003_attenRel, iml);
        wt += prob;
        prob = this.getExceedProbability(this.scemy_1997_attenRel, iml);
        epsilon += prob * this.getEpsilon(this.scemy_1997_attenRel, iml);
        wt += prob;
        if (this.im.getName().equals("SA") && per >= 3.0) {
            return epsilon / wt;
        }
        prob = this.getExceedProbability(this.bjf_1997_attenRel, iml);
        return (epsilon += prob * this.getEpsilon(this.bjf_1997_attenRel, iml)) / (wt += prob);
    }

    public double getExceedProbability() throws ParameterException, IMRException {
        if (this.im.getName().equals(MMI_NAME)) {
            throw new RuntimeException(MMI_ERROR_STRING);
        }
        this.vs30 = (Double)this.vs30Param.getValue();
        this.setAttenRelsStdDevTypes();
        this.setAttenRelsIMT();
        return this.getCombinedExceedProbability((Double)this.im.getValue());
    }

    public double getEpsilon() {
        if (this.im.getName().equals(MMI_NAME)) {
            throw new RuntimeException(MMI_ERROR_STRING);
        }
        this.vs30 = (Double)this.vs30Param.getValue();
        this.setAttenRelsStdDevTypes();
        this.setAttenRelsIMT();
        return this.getCombinedEpsilon((Double)this.im.getValue());
    }

    public DiscretizedFuncAPI getExceedProbabilities(DiscretizedFuncAPI intensityMeasureLevels) throws ParameterException {
        if (this.im.getName().equals(MMI_NAME)) {
            throw new RuntimeException(MMI_ERROR_STRING);
        }
        this.vs30 = (Double)this.vs30Param.getValue();
        this.setAttenRelsStdDevTypes();
        this.setAttenRelsIMT();
        Iterator<DataPoint2D> it = intensityMeasureLevels.getPointsIterator();
        while (it.hasNext()) {
            DataPoint2D point = it.next();
            point.setY(this.getCombinedExceedProbability(point.getX()));
        }
        return intensityMeasureLevels;
    }

    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.pgvParam.setValueAsDefault();
        this.mmiParam.setValue(MMI_DEFAULT);
        this.componentParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameter(this.vs30Param);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    protected void initEqkRuptureParams() {
    }

    protected void initPropagationEffectParams() {
    }

    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        periodConstraint.addDouble(0.0);
        periodConstraint.addDouble(0.1);
        periodConstraint.addDouble(0.2);
        periodConstraint.addDouble(0.3);
        periodConstraint.addDouble(0.4);
        periodConstraint.addDouble(0.5);
        periodConstraint.addDouble(0.75);
        periodConstraint.addDouble(1.0);
        periodConstraint.addDouble(1.5);
        periodConstraint.addDouble(2.0);
        periodConstraint.addDouble(3.0);
        periodConstraint.addDouble(4.0);
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.mmiParam = new DoubleParameter(MMI_NAME, MMI_MIN, MMI_MAX);
        this.mmiParam.setInfo(MMI_INFO);
        this.mmiParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.pgvParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
        this.supportedIMParams.addParameter(this.mmiParam);
    }

    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint constraint = new StringConstraint();
        constraint.addString("Average Horizontal");
        constraint.addString(COMPONENT_GREATER_OF_TWO_HORZ);
        constraint.setNonEditable();
        this.componentParam = new ComponentParam(constraint, "Average Horizontal");
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    protected void initCoefficients() {
    }

    protected void setPropagationEffectParams() {
    }

    public ListIterator getEqkRuptureParamsIterator() {
        throw new RuntimeException(UNSUPPORTED_METHOD_ERROR);
    }

    public ListIterator getPropagationEffectParamsIterator() {
        throw new RuntimeException(UNSUPPORTED_METHOD_ERROR);
    }

    public ListIterator getExceedProbIndependentParamsIterator() {
        throw new RuntimeException(UNSUPPORTED_METHOD_ERROR);
    }

    public ListIterator getMeanIndependentParamsIterator() {
        throw new RuntimeException(UNSUPPORTED_METHOD_ERROR);
    }

    public ListIterator getStdDevIndependentParamsIterator() {
        throw new RuntimeException(UNSUPPORTED_METHOD_ERROR);
    }

    public ListIterator getIML_AtExceedProbIndependentParamsIterator() {
        throw new RuntimeException(UNSUPPORTED_METHOD_ERROR);
    }

    public static void main(String[] args) {
        USGS_Combined_2004_AttenRel ar = new USGS_Combined_2004_AttenRel(null);
        ar.setParamDefaults();
        Site site = new Site(new Location(34.0, -117.0, 0.0));
        site.addParameter(ar.getParameter("Vs30"));
        ProbEqkRupture qk = new ProbEqkRupture(6.25, 0.0, 8.27442E-4, new PointSurface(34.0, -117.0, 0.0), null);
        ar.setEqkRupture(qk);
        ar.setSite(site);
        ar.setIntensityMeasure("PGA");
        System.out.println(ar.getMean());
        System.out.println(ar.getStdDev());
        PropagationEffect pe = new PropagationEffect();
        pe.setAll(qk, site);
        System.out.println(pe.getParamValue("DistanceSeis"));
        System.out.println(ar.getMean());
        System.out.println(ar.getStdDev());
    }

    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/documentation/modelsImplemented/attenRel/USGS_Combined_2004.html");
    }
}

