/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.PropagationEffectParams;

import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Location;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.ParameterConstraintAPI;
import org.opensha.commons.param.WarningParameterAPI;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.imr.param.PropagationEffectParams.WarningDoublePropagationEffectParameter;

public class DistanceJBParameter
extends WarningDoublePropagationEffectParameter
implements WarningParameterAPI {
    protected static final String C = "DistanceJBParameter";
    protected static final boolean D = false;
    protected boolean fix_dist_JB = false;
    public static final String NAME = "DistanceJB";
    private static final String UNITS = "km";
    private static final String INFO = "Joyner-Boore Distance (closest distance to surface projection of fault)";
    private static final Double MIN = new Double(0.0);
    private static final Double MAX = new Double(Double.MAX_VALUE);

    public DistanceJBParameter() {
        this.init();
    }

    public DistanceJBParameter(double defaultValue) {
        this.init();
        this.setDefaultValue(defaultValue);
    }

    public DistanceJBParameter(ParameterConstraintAPI warningConstraint) throws ConstraintException {
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceJBParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
    }

    public DistanceJBParameter(ParameterConstraintAPI warningConstraint, double defaultValue) throws ConstraintException {
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceJBParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
        this.setDefaultValue(defaultValue);
    }

    protected void init(DoubleConstraint warningConstraint) {
        this.warningConstraint = warningConstraint;
        this.constraint = new DoubleConstraint(MIN, MAX);
        this.constraint.setNullAllowed(false);
        this.name = NAME;
        this.constraint.setName(this.name);
        this.units = UNITS;
        this.info = INFO;
    }

    protected void init() {
        this.init(null);
    }

    protected void calcValueFromSiteAndEqkRup() {
        if (this.site != null && this.eqkRupture != null) {
            Location loc2;
            Location loc1 = this.site.getLocation();
            double minDistance = 999999.0;
            EvenlyGriddedSurfaceAPI rupSurf = this.eqkRupture.getRuptureSurface();
            ListIterator it = rupSurf.getAveDip() > 89.0 ? rupSurf.getColumnIterator(0) : rupSurf.getLocationsIterator();
            while (it.hasNext()) {
                loc2 = (Location)it.next();
                double currentDistance = RelativeLocation.getHorzDistance(loc1, loc2);
                if (!(currentDistance < minDistance)) continue;
                minDistance = currentDistance;
            }
            if (this.fix_dist_JB && rupSurf.getNumCols() > 1 && rupSurf.getNumRows() > 1) {
                loc1 = rupSurf.getLocation(0, 0);
                loc2 = rupSurf.getLocation(1, 1);
                double d1 = RelativeLocation.getHorzDistance(loc1, loc2);
                loc1 = rupSurf.getLocation(0, 1);
                loc2 = rupSurf.getLocation(1, 0);
                double d2 = RelativeLocation.getHorzDistance(loc1, loc2);
                double min_dist = Math.min(d1, d1) / 2.0;
                if (minDistance <= min_dist) {
                    minDistance = 0.0;
                }
            }
            this.setValueIgnoreWarning(new Double(minDistance));
        } else {
            this.setValue((Object)null);
        }
    }

    public void fixDistanceJB(boolean fixIt) {
        this.fix_dist_JB = fixIt;
    }

    public String getType() {
        String type = "DoubleParameter";
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public Object clone() {
        DoubleConstraint c1 = null;
        DoubleConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (DoubleConstraint)this.warningConstraint.clone();
        }
        Double val = null;
        Double val2 = null;
        if (this.value != null) {
            val = (Double)this.value;
            val2 = new Double(val);
        }
        DistanceJBParameter param = new DistanceJBParameter();
        param.info = this.info;
        param.value = val2;
        param.constraint = c1;
        param.warningConstraint = c2;
        param.name = this.name;
        param.info = this.info;
        param.site = this.site;
        param.eqkRupture = this.eqkRupture;
        if (!this.editable) {
            param.setNonEditable();
        }
        return param;
    }

    public boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }
}

