/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.PropagationEffectParams;

import org.dom4j.Element;
import org.opensha.commons.calc.RelativeLocation;
import org.opensha.commons.data.Direction;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.region.BorderType;
import org.opensha.commons.data.region.Region;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.param.DoubleConstraint;
import org.opensha.commons.param.ParameterConstraintAPI;
import org.opensha.commons.param.WarningParameterAPI;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.MeanUCERF2.MeanUCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfaceAPI;
import org.opensha.sha.imr.param.PropagationEffectParams.WarningDoublePropagationEffectParameter;

public class DistanceX_Parameter
extends WarningDoublePropagationEffectParameter
implements WarningParameterAPI {
    protected static final String C = "DistanceJBParameter";
    protected static final boolean D = true;
    public static final String NAME = "DistanceX";
    private static final String UNITS = "km";
    private static final String INFO = "Horizontal distance to top edge of rupture, measured ppd to strike; neg valuse are on the foot wall";
    private static final Double MIN = new Double(-1.7976931348623157E308);
    private static final Double MAX = new Double(Double.MAX_VALUE);

    public DistanceX_Parameter() {
        this.init();
    }

    public DistanceX_Parameter(double defaultValue) {
        this.init();
        this.setDefaultValue(defaultValue);
    }

    public DistanceX_Parameter(ParameterConstraintAPI warningConstraint) throws ConstraintException {
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceJBParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
    }

    public DistanceX_Parameter(ParameterConstraintAPI warningConstraint, double defaultValue) throws ConstraintException {
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceJBParameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
        this.setDefaultValue(defaultValue);
    }

    protected void init(DoubleConstraint warningConstraint) {
        this.warningConstraint = warningConstraint;
        this.constraint = new DoubleConstraint(MIN, MAX);
        this.constraint.setNullAllowed(false);
        this.name = NAME;
        this.constraint.setName(this.name);
        this.units = UNITS;
        this.info = INFO;
    }

    protected void init() {
        this.init(null);
    }

    protected void calcValueFromSiteAndEqkRup() {
        if (this.site != null && this.eqkRupture != null) {
            Location siteLoc = this.site.getLocation();
            EvenlyGriddedSurfaceAPI rupSurf = this.eqkRupture.getRuptureSurface();
            if (rupSurf.getNumCols() == 1) {
                this.setValue((Object)0.0);
            } else {
                Location loc;
                int l;
                Location firstTraceLoc = rupSurf.getLocation(0, 0);
                Location lastTraceLoc = rupSurf.getLocation(0, rupSurf.getNumCols() - 1);
                Direction dir = RelativeLocation.getDirection(lastTraceLoc, firstTraceLoc);
                dir.setHorzDistance(1000.0);
                Location projectedLoc1 = RelativeLocation.getLocation(firstTraceLoc, dir);
                dir.setAzimuth(dir.getAzimuth() + 180.0);
                Location projectedLoc2 = RelativeLocation.getLocation(lastTraceLoc, dir);
                dir.setAzimuth(dir.getAzimuth() + 90.0);
                Location projectedLoc3 = RelativeLocation.getLocation(projectedLoc1, dir);
                Location projectedLoc4 = RelativeLocation.getLocation(projectedLoc2, dir);
                LocationList locsForExtendedTrace = new LocationList();
                LocationList locsForRegion = new LocationList();
                locsForExtendedTrace.addLocation(projectedLoc1);
                locsForRegion.addLocation(projectedLoc1);
                for (int c = 0; c < rupSurf.getNumCols(); ++c) {
                    locsForExtendedTrace.addLocation(rupSurf.getLocation(0, c));
                    locsForRegion.addLocation(rupSurf.getLocation(0, c));
                }
                locsForExtendedTrace.addLocation(projectedLoc2);
                locsForRegion.addLocation(projectedLoc2);
                locsForRegion.addLocation(projectedLoc4);
                locsForRegion.addLocation(projectedLoc3);
                System.out.println("Projected Trace:");
                for (l = 0; l < locsForExtendedTrace.size(); ++l) {
                    loc = locsForExtendedTrace.getLocationAt(l);
                    System.out.println(loc.getLatitude() + "\t" + loc.getLongitude() + "\t" + loc.getDepth());
                }
                System.out.println("Region:");
                for (l = 0; l < locsForRegion.size(); ++l) {
                    loc = locsForRegion.getLocationAt(l);
                    System.out.println(loc.getLatitude() + "\t" + loc.getLongitude() + "\t" + loc.getDepth());
                }
                Region polygon = new Region(locsForRegion, BorderType.MERCATOR_LINEAR);
                boolean isInside = polygon.contains(siteLoc);
                double distToExtendedTrace = locsForExtendedTrace.getMinHorzDistToLine(siteLoc);
                if (isInside || distToExtendedTrace == 0.0) {
                    this.setValue((Object)distToExtendedTrace);
                } else {
                    this.setValue((Object)(-distToExtendedTrace));
                }
            }
        } else {
            this.setValue((Object)null);
        }
    }

    public String getType() {
        String type = "DoubleParameter";
        ParameterConstraintAPI constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + type;
        }
        return type;
    }

    public Object clone() {
        DoubleConstraint c1 = null;
        DoubleConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (DoubleConstraint)this.warningConstraint.clone();
        }
        Double val = null;
        Double val2 = null;
        if (this.value != null) {
            val = (Double)this.value;
            val2 = new Double(val);
        }
        DistanceX_Parameter param = new DistanceX_Parameter();
        param.info = this.info;
        param.value = val2;
        param.constraint = c1;
        param.warningConstraint = c2;
        param.name = this.name;
        param.info = this.info;
        param.site = this.site;
        param.eqkRupture = this.eqkRupture;
        if (!this.editable) {
            param.setNonEditable();
        }
        return param;
    }

    public boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }

    public static void main(String[] args) {
        MeanUCERF2 meanUCERF2 = new MeanUCERF2();
        meanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        meanUCERF2.updateForecast();
        ProbEqkRupture sierraMadreRup = meanUCERF2.getSource(271).getRupture(meanUCERF2.getSource(271).getNumRuptures() - 1);
        Site site = new Site();
        site.setLocation(sierraMadreRup.getRuptureSurface().getLocation(0, 0));
        DistanceX_Parameter distX = new DistanceX_Parameter();
        distX.setValue(sierraMadreRup, site);
    }
}

