/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.griddedForecast.GriddedHypoMagFreqDistForecast;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.step.calc.RegionDefaults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackGroundRatesGrid
extends GriddedHypoMagFreqDistForecast {
    private static Logger logger = Logger.getLogger(BackGroundRatesGrid.class);
    private double minForecastMag;
    private double maxForecastMag;
    private double deltaForecastMag;
    private double minMagInSourceFile = 2.0;
    private double[] seqIndAtNode;
    private boolean deltaSourcesAlreadyMade = false;
    private boolean backgroundSourcesAlreadyMade = false;
    private boolean backgroundRatesFileAlreadyRead = false;
    private String bgGridFilename = RegionDefaults.BACKGROUND_RATES_FILE_NAME;
    private static final double RAKE = 0.0;
    private static final double DIP = 90.0;
    public static final double DEPTH = 0.0;
    private final double GRID_SPACING = 0.1;
    private ArrayList<HypoMagFreqDistAtLoc> hypoMagFreqDist;
    private ArrayList backGroundSourceList;

    public BackGroundRatesGrid() {
        this.minForecastMag = RegionDefaults.minForecastMag;
        this.maxForecastMag = RegionDefaults.maxForecastMag;
        this.deltaForecastMag = RegionDefaults.deltaForecastMag;
    }

    public BackGroundRatesGrid(double minForecastMag, double maxForecastMag, double deltaForecastMag) {
        this.minForecastMag = minForecastMag;
        this.maxForecastMag = maxForecastMag;
        this.deltaForecastMag = deltaForecastMag;
    }

    public BackGroundRatesGrid(String fileName) {
        this();
        this.setBgGridFilename(fileName);
        this.initialize();
    }

    public void initialize() {
        this.createBackGroundRegion();
        this.loadBackGroundRatesFromFile(this.bgGridFilename);
        this.initSeqIndices();
    }

    public void initSeqIndices() {
        if (this.seqIndAtNode == null) {
            this.seqIndAtNode = new double[this.getRegion().getNodeCount()];
        }
        logger.info((Object)("seqIndAtNode " + this.seqIndAtNode.length));
        Arrays.fill(this.seqIndAtNode, -1.0);
    }

    public void setBgGridFilename(String bgGridFilename) {
        this.bgGridFilename = bgGridFilename;
    }

    private void createBackGroundRegion() {
        this.setBackGroundRegion(this.getDefaultRegion());
    }

    public GriddedRegion getDefaultRegion() {
        return new GriddedRegion(new Location(RegionDefaults.searchLatMin, RegionDefaults.searchLongMin), new Location(RegionDefaults.searchLatMax, RegionDefaults.searchLongMax), RegionDefaults.gridSpacing, new Location(RegionDefaults.grid_anchor, RegionDefaults.grid_anchor));
    }

    public void loadBackGroundRatesFromFile(String fileName) {
        ArrayList<String> backgroundRateFileLines = null;
        if (!this.backgroundRatesFileAlreadyRead) {
            try {
                logger.info((Object)("loadBackGroundGridFromFile fileName " + new File(fileName).getAbsolutePath()));
                backgroundRateFileLines = FileUtils.loadFile(fileName);
            }
            catch (Exception e) {
                throw new RuntimeException("Background file could not be loaded");
            }
            this.backgroundRatesFileAlreadyRead = true;
        }
        GriddedRegion region = this.getRegion();
        HashMap<String, HypoMagFreqDistAtLoc> hypoMagFreqDistMap = new HashMap<String, HypoMagFreqDistAtLoc>();
        ListIterator it = backgroundRateFileLines.listIterator();
        int forecastMagStart = this.getForecastMagStart();
        logger.info((Object)(" backgroundRateFileLines " + backgroundRateFileLines.size()));
        while (it.hasNext()) {
            String line = ((String)it.next()).toString();
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            double lon = Double.parseDouble(st.nextToken());
            double lat = Double.parseDouble(st.nextToken());
            int numForecastMags = 1 + (int)((this.maxForecastMag - this.minForecastMag) / this.deltaForecastMag);
            IncrementalMagFreqDist magFreqDist = new IncrementalMagFreqDist(this.minForecastMag, this.maxForecastMag, numForecastMags);
            for (int j = 0; j < forecastMagStart; ++j) {
                st.nextToken();
            }
            for (int i = 0; i < numForecastMags; ++i) {
                if (!st.hasMoreTokens()) continue;
                double rate = Double.parseDouble(st.nextToken());
                magFreqDist.set(i, rate);
            }
            Location loc = new Location(lat, lon, 0.0);
            hypoMagFreqDistMap.put(this.getKey4Location(loc), new HypoMagFreqDistAtLoc(magFreqDist, loc));
        }
        this.hypoMagFreqDist = new ArrayList();
        for (int i = 0; i < region.getNodeCount(); ++i) {
            Location loc = region.getNodeList().getLocationAt(i);
            HypoMagFreqDistAtLoc hypoMagFreqDistAtLoc = (HypoMagFreqDistAtLoc)hypoMagFreqDistMap.get(this.getKey4Location(loc));
            if (hypoMagFreqDistAtLoc == null) {
                // empty if block
            }
            this.hypoMagFreqDist.add(hypoMagFreqDistAtLoc);
        }
        this.backgroundSourcesAlreadyMade = true;
    }

    public String getKey4Location(Location loc) {
        return Math.round(loc.getLatitude() / RegionDefaults.gridPrecision) + "_" + Math.round(loc.getLongitude() / RegionDefaults.gridPrecision);
    }

    public int getForecastMagStart() {
        double diff = this.minForecastMag - this.minMagInSourceFile;
        if (diff <= 0.0) {
            return 0;
        }
        return (int)Math.round(diff / this.deltaForecastMag);
    }

    public void setBackGroundRegion(GriddedRegion backGroundRegion) {
        this.setRegion(backGroundRegion);
    }

    public void setMinForecastMag(double minMag) {
        this.minForecastMag = minMag;
    }

    public void setMaxForecastMag(double maxMag) {
        this.maxForecastMag = maxMag;
    }

    public void setDeltaForecastMag(double deltaMag) {
        this.deltaForecastMag = deltaMag;
    }

    public void setSeqIndAtNode(int ithLocation, int seqInd) {
        this.seqIndAtNode[ithLocation] = seqInd;
    }

    @Override
    public HypoMagFreqDistAtLoc getHypoMagFreqDistAtLoc(int ithLocation) {
        return this.hypoMagFreqDist.get(ithLocation);
    }

    public ArrayList<HypoMagFreqDistAtLoc> getMagDistList() {
        return this.hypoMagFreqDist;
    }

    public void setMagFreqDistAtLoc(IncrementalMagFreqDist locDist, int ithLocation) {
        HypoMagFreqDistAtLoc tmpFreqDistAtLoc = this.hypoMagFreqDist.get(ithLocation);
        Location tmpLoc = tmpFreqDistAtLoc.getLocation();
        HypoMagFreqDistAtLoc newFreqDistAtLoc = new HypoMagFreqDistAtLoc(locDist, tmpLoc);
        this.hypoMagFreqDist.set(ithLocation, newFreqDistAtLoc);
    }

    public void setMagFreqDistAtLocation(IncrementalMagFreqDist locDist, Location loc) {
        HypoMagFreqDistAtLoc newFreqDistAtLoc = new HypoMagFreqDistAtLoc(locDist, loc);
    }

    public double[] getSeqIndAtNode() {
        return this.seqIndAtNode;
    }

    public boolean isBackgroundSourcesAlreadyMade() {
        return this.backgroundSourcesAlreadyMade;
    }

    public boolean isBackgroundRatesFileAlreadyRead() {
        return this.backgroundRatesFileAlreadyRead;
    }

    public ArrayList getBackGroundSourceList() {
        return this.backGroundSourceList;
    }

    public ArrayList getHypoMagFreqDist() {
        return this.hypoMagFreqDist;
    }

    public boolean checkLocaionEquals(Location loc1, Location loc2, double precision) {
        if (Math.round(loc1.getLatitude() / precision) != Math.round(loc2.getLatitude() / precision)) {
            return false;
        }
        if (Math.round(loc1.getLongitude() / precision) != Math.round(loc2.getLongitude() / precision)) {
            return false;
        }
        return Math.round(loc1.getDepth() / precision) == Math.round(loc2.getDepth() / precision);
    }
}

