/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.BorderType;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.step.calc.RegionDefaults;

public class CountObsInGrid {
    private int numGridNodes;
    private GriddedRegion region;
    private int[] numObsInGrid;
    private ObsEqkRupList obsEvents;

    public CountObsInGrid(ObsEqkRupList obsEvents, GriddedRegion region) {
        this.obsEvents = obsEvents;
        this.region = region;
        this.numGridNodes = this.region.getNodeCount();
        this.numObsInGrid = new int[this.numGridNodes];
        this.countEventsInCell();
    }

    public int[] getNumObsInGridList() {
        return this.numObsInGrid;
    }

    public void countEventsInCell() {
        LocationList cellLoc = new LocationList();
        int gLoop = 0;
        while (gLoop < this.numGridNodes) {
            cellLoc.clear();
            Location gridCenter = this.region.locationForIndex(gLoop);
            double gLat = gridCenter.getLatitude();
            double gLong = gridCenter.getLongitude();
            Location gridCorner1 = new Location(gLat + RegionDefaults.gridSpacing / 2.0, gLong + RegionDefaults.gridSpacing / 2.0);
            cellLoc.addLocationAt(gridCorner1, 0);
            Location gridCorner2 = new Location(gLat - RegionDefaults.gridSpacing / 2.0, gLong + RegionDefaults.gridSpacing / 2.0);
            cellLoc.addLocationAt(gridCorner2, 1);
            Location gridCorner3 = new Location(gLat - RegionDefaults.gridSpacing / 2.0, gLong - RegionDefaults.gridSpacing / 2.0);
            cellLoc.addLocationAt(gridCorner3, 2);
            Location gridCorner4 = new Location(gLat + RegionDefaults.gridSpacing / 2.0, gLong - RegionDefaults.gridSpacing / 2.0);
            cellLoc.addLocationAt(gridCorner4, 3);
            Region gridRegion = new Region(cellLoc, BorderType.MERCATOR_LINEAR);
            ObsEqkRupList cellEvents = this.obsEvents.getObsEqkRupsInside(gridRegion);
            this.numObsInGrid[gLoop++] = cellEvents.size();
        }
    }
}

