/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.data.region.Region;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.step.calc.CompletenessMagCalc;
import org.opensha.step.calc.MaxLikeGR_Calc;
import org.opensha.step.calc.MaxLikeOmori_Calc;

public class ReasenbergJonesGriddedParms_Calc
implements Serializable {
    private boolean useFixed_cValue = true;
    private double[] grid_pVal;
    private double[] grid_cVal;
    private double[] grid_kVal;
    private double[] grid_aVal;
    private double[] grid_bVal;
    private double[] grid_Mc;
    private double constantAddToMc = 0.2;
    private double searchRadius;

    public ReasenbergJonesGriddedParms_Calc(GriddedRegion gridNodes, ObsEqkRupList eventList, boolean useFixed_cValue) {
        this.setGriddedMags(gridNodes, eventList);
        this.setUseFixed_cVal(useFixed_cValue);
    }

    public ReasenbergJonesGriddedParms_Calc(GriddedRegion gridNodes, ObsEqkRupList eventList) {
        this.setGriddedMags(gridNodes, eventList);
    }

    public void setUseFixed_cVal(boolean fix_cVal) {
        this.useFixed_cValue = fix_cVal;
    }

    public void set_constantAddToCompleteness(double mcConst) {
        this.constantAddToMc = mcConst;
    }

    public double[] get_Gridded_pVals() {
        return this.grid_pVal;
    }

    public double[] get_Gridded_cVals() {
        return this.grid_cVal;
    }

    public double[] get_Gridded_kVals() {
        return this.grid_kVal;
    }

    public double[] get_Gridded_aVals() {
        return this.grid_aVal;
    }

    public double[] get_Gridded_bVals() {
        return this.grid_bVal;
    }

    public ArrayList getAllGriddedVals() {
        ArrayList<double[]> RJParms = new ArrayList<double[]>(5);
        RJParms.add(0, this.grid_aVal);
        RJParms.add(1, this.grid_bVal);
        RJParms.add(2, this.grid_pVal);
        RJParms.add(3, this.grid_kVal);
        RJParms.add(4, this.grid_cVal);
        RJParms.add(5, this.grid_Mc);
        return RJParms;
    }

    public void setGriddedMags(GriddedRegion gridNodes, ObsEqkRupList eventList) {
        this.calc_RJParmsOnGrid(gridNodes, eventList);
    }

    private void calc_RJParmsOnGrid(GriddedRegion gridNodes, ObsEqkRupList eventList) {
        Iterator<Location> gridIt = gridNodes.getNodeList().iterator();
        int numNodes = gridNodes.getNodeCount();
        this.grid_aVal = new double[numNodes];
        this.grid_bVal = new double[numNodes];
        this.grid_pVal = new double[numNodes];
        this.grid_kVal = new double[numNodes];
        this.grid_cVal = new double[numNodes];
        this.grid_Mc = new double[numNodes];
        int numEvents = eventList.size();
        double[] eventDist = new double[numEvents];
        int ind = 0;
        CompletenessMagCalc compMagCalc = new CompletenessMagCalc(eventList);
        double allEventsMc = compMagCalc.getMcBest() + this.constantAddToMc;
        int totalCompleteEvents = eventList.getObsEqkRupsAboveMag(allEventsMc).size();
        this.searchRadius = totalCompleteEvents < 1000 ? 15.0 : (totalCompleteEvents < 1500 ? 12.0 : (totalCompleteEvents < 2000 ? 10.0 : 75.0));
        while (gridIt.hasNext()) {
            Location loc = gridIt.next();
            if (loc == null) continue;
            Region gridRegion = new Region(loc, this.searchRadius);
            ObsEqkRupList regionList = eventList.getObsEqkRupsInside(gridRegion);
            if (regionList.size() == 0) {
                this.grid_aVal[ind] = Double.NaN;
                this.grid_bVal[ind] = Double.NaN;
                this.grid_Mc[ind] = Double.NaN;
                this.grid_cVal[ind] = Double.NaN;
                this.grid_pVal[ind] = Double.NaN;
                this.grid_kVal[ind++] = Double.NaN;
                continue;
            }
            CompletenessMagCalc compMagCalc1 = new CompletenessMagCalc(regionList);
            double completenessMag = compMagCalc1.getMcBest();
            this.grid_Mc[ind] = completenessMag + this.constantAddToMc;
            ObsEqkRupList completeRegionList = regionList.getObsEqkRupsAboveMag(completenessMag + this.constantAddToMc);
            MaxLikeGR_Calc maxLikeGR_Calc = new MaxLikeGR_Calc();
            if (completeRegionList.size() != 0) {
                maxLikeGR_Calc.setMags(completeRegionList);
            }
            if (completeRegionList.size() >= 100) {
                this.grid_aVal[ind] = maxLikeGR_Calc.get_aValueMaxLike();
                this.grid_bVal[ind] = maxLikeGR_Calc.get_bValueMaxLike();
                MaxLikeOmori_Calc omoriCalc = new MaxLikeOmori_Calc();
                if (this.useFixed_cValue) {
                    omoriCalc.set_AfterShockListFixed_c(completeRegionList);
                } else {
                    omoriCalc.set_AfterShockList(completeRegionList);
                }
                this.grid_cVal[ind] = omoriCalc.get_c_value();
                this.grid_pVal[ind] = omoriCalc.get_p_value();
                this.grid_kVal[ind++] = omoriCalc.get_k_value();
                continue;
            }
            this.grid_aVal[ind] = Double.NaN;
            this.grid_bVal[ind] = Double.NaN;
            this.grid_cVal[ind] = Double.NaN;
            this.grid_pVal[ind] = Double.NaN;
            this.grid_kVal[ind++] = Double.NaN;
        }
    }

    public double getGridSearchRadius() {
        return this.searchRadius;
    }
}

