/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ListIterator;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.sha.earthquake.griddedForecast.STEP_CombineForecastModels;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;

public class STEP_TypeIIAftershockZone_Calc {
    private GriddedRegion typeIIAftershockZone;
    private LocationList faultSegments;
    private double zoneRadius;
    private double gridSpacing;
    private Comparator<Location> locationComparatorByLong = new Comparator<Location>(){

        @Override
        public int compare(Location loc1, Location loc2) {
            double longdiff = loc1.getLongitude() - loc2.getLongitude();
            if (longdiff == 0.0) {
                double latdiff = loc1.getLatitude() - loc2.getLatitude();
                if (latdiff == 0.0) {
                    return 0;
                }
                return latdiff > 0.0 ? 1 : -1;
            }
            return longdiff > 0.0 ? 1 : -1;
        }
    };
    private Comparator<Location> locationComparatorByLat = new Comparator<Location>(){

        @Override
        public int compare(Location loc1, Location loc2) {
            double latdiff = loc1.getLatitude() - loc2.getLatitude();
            if (latdiff == 0.0) {
                double longdiff = loc1.getLongitude() - loc2.getLongitude();
                if (longdiff == 0.0) {
                    return 0;
                }
                return longdiff > 0.0 ? 1 : -1;
            }
            return latdiff > 0.0 ? 1 : -1;
        }
    };

    public STEP_TypeIIAftershockZone_Calc(ObsEqkRupList newObsEventsList, STEP_CombineForecastModels aftershockModel) {
        ObsEqkRupture mainshock = aftershockModel.getMainShock();
        Location mainshockLoc = mainshock.getHypocenterLocation();
        this.gridSpacing = aftershockModel.get_GridSpacing();
        this.zoneRadius = aftershockModel.get_AftershockZoneRadius();
        this.calc_SyntheticFault(newObsEventsList, mainshockLoc);
    }

    public void calc_SyntheticFault(ObsEqkRupList newObsEventsList, Location mainshockLoc) {
        ListIterator eventIt = newObsEventsList.listIterator();
        int numEvents = newObsEventsList.size();
        ObsEqkRupture event = new ObsEqkRupture();
        Location eLoc = new Location();
        ArrayList<Location> latLongList = new ArrayList<Location>();
        while (eventIt.hasNext()) {
            event = (ObsEqkRupture)eventIt.next();
            eLoc = event.getHypocenterLocation();
            latLongList.add(eLoc);
        }
        int minInd = (int)Math.round(0.01 * (double)numEvents);
        int maxInd = (int)Math.round(0.99 * (double)numEvents);
        int numIn = (int)Math.round(0.8 * (double)numEvents);
        Collections.sort(latLongList, this.locationComparatorByLat);
        double maxLat_LatSort = ((Location)latLongList.get(maxInd)).getLatitude();
        double minLat_LatSort = ((Location)latLongList.get(minInd)).getLatitude();
        double maxLong_LatSort = ((Location)latLongList.get(maxInd)).getLongitude();
        double minLong_LatSort = ((Location)latLongList.get(minInd)).getLongitude();
        Collections.sort(latLongList, this.locationComparatorByLong);
        double maxLong_LongSort = ((Location)latLongList.get(maxInd)).getLongitude();
        double minLong_LongSort = ((Location)latLongList.get(minInd)).getLongitude();
        double maxLat_LongSort = ((Location)latLongList.get(maxInd)).getLatitude();
        double minLat_LongSort = ((Location)latLongList.get(minInd)).getLatitude();
        double latDiff = maxLat_LatSort - minLat_LatSort;
        double longDiff = maxLong_LongSort - minLong_LongSort;
        this.faultSegments = new LocationList();
        Location topEndPoint = new Location();
        Location bottomEndPoint = new Location();
        if (latDiff > longDiff) {
            topEndPoint.setLatitude(maxLat_LatSort);
            topEndPoint.setLongitude(maxLong_LatSort);
            bottomEndPoint.setLatitude(minLat_LatSort);
            bottomEndPoint.setLongitude(minLong_LatSort);
        } else {
            topEndPoint.setLatitude(maxLat_LongSort);
            topEndPoint.setLongitude(maxLong_LongSort);
            bottomEndPoint.setLatitude(minLat_LongSort);
            bottomEndPoint.setLongitude(minLong_LongSort);
        }
        this.faultSegments.addLocation(topEndPoint);
        this.faultSegments.addLocation(mainshockLoc);
        this.faultSegments.addLocation(bottomEndPoint);
    }

    public void CreateAftershockZoneDef() {
        this.typeIIAftershockZone = new GriddedRegion(this.faultSegments, this.zoneRadius, this.gridSpacing, new Location(0.0, 0.0));
    }

    public GriddedRegion get_TypeIIAftershockZone() {
        return this.typeIIAftershockZone;
    }

    public LocationList getTypeIIFaultModel() {
        return this.faultSegments;
    }
}

