/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.step.calc;

import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.ListIterator;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.opensha.commons.data.Location;
import org.opensha.commons.data.LocationList;
import org.opensha.commons.data.region.GriddedRegion;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.griddedForecast.HypoMagFreqDistAtLoc;
import org.opensha.sha.earthquake.griddedForecast.STEP_CombineForecastModels;
import org.opensha.sha.earthquake.observedEarthquake.CubeToObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.CubeToObsEqkRuptureChinaFormat;
import org.opensha.sha.earthquake.observedEarthquake.CubeToObsEqkRuptureCsepFormat;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.rupForecastImpl.PointEqkSource;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.step.calc.ApplyCoulombFilter;
import org.opensha.step.calc.BackGroundRatesGrid;
import org.opensha.step.calc.IsAftershockToMainshock_Calc;
import org.opensha.step.calc.PurgeMainshockList;
import org.opensha.step.calc.QuakeMLClient;
import org.opensha.step.calc.RegionDefaults;
import org.opensha.step.calc.STEP_HazardDataSet;
import org.opensha.step.calc.UpdateSTEP_Forecast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STEP_main {
    private static Logger logger = Logger.getLogger(STEP_main.class);
    private GregorianCalendar currentTime;
    GregorianCalendar lastCurrTime;
    private GregorianCalendar eventStartTime;
    private DecimalFormat locFormat = new DecimalFormat("0.0000");
    private DecimalFormat magFormat = new DecimalFormat("0.00");
    public static SimpleDateFormat localDateformater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private String eventsFilePath = RegionDefaults.cubeFilePath;
    private String bgRatesFilePath = RegionDefaults.BACKGROUND_RATES_FILE_NAME;
    private boolean scheduledOperation = false;
    private boolean recheckAftershocks4sausageModel = false;
    private UpdateSTEP_Forecast updateModel;
    private ArrayList<STEP_CombineForecastModels> STEP_AftershockForecastList;
    private BackGroundRatesGrid bgGrid = null;
    private ArrayList<PointEqkSource> sourceList;

    public static void main(String[] args) {
        STEP_main step;
        long start = System.currentTimeMillis();
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option paramFile = parser.addStringOption('f', "file");
        try {
            parser.parse(args);
            String paramFilePath = (String)parser.getOptionValue(paramFile);
            STEP_main.log(">> paramFilePath=" + paramFilePath);
            System.out.println("TEST!!" + RegionDefaults.PARAM_FILE_BY_COMMAND_ARGS);
            if (RegionDefaults.EVENT_DATA_SOURCE == 3 && RegionDefaults.PARAM_FILE_BY_COMMAND_ARGS) {
                STEP_main.setCsepParamFile(paramFilePath);
            }
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            STEP_main.printUsage();
            System.exit(2);
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
            STEP_main.printUsage();
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            STEP_main.printUsage();
            System.exit(2);
        }
        args = parser.getRemainingArgs();
        if (args.length > 0) {
            if ("1".equals(args[0])) {
                STEP_main.log("run STEP_HazardDataSet");
                STEP_HazardDataSet.main(args);
            } else if ("0".equals(args[0])) {
                step = new STEP_main();
                step.calc_STEP(null, null);
            } else {
                STEP_main.printUsage();
            }
        } else {
            step = new STEP_main();
            step.calc_STEP(null, null);
        }
        long elapsedTimeMillis = System.currentTimeMillis() - start;
        float elapsedTimeMin = (float)elapsedTimeMillis / 60000.0f;
        System.out.println(elapsedTimeMin);
    }

    private static void setCsepParamFile(String paramFilePath) throws FileNotFoundException, IOException {
        if (paramFilePath == null) {
            System.err.println("Please enter a valid parameter file!");
            STEP_main.printUsage();
            System.exit(2);
        } else {
            RegionDefaults.setCsepParams(paramFilePath);
        }
    }

    private static void printUsage() {
        System.out.println(" Usage:\n run_step [0] {-f param-file-path}  \n run_step [1] {-f param-file-path}  \n run_step [1] {c} {-f param-file-path}  \n run_step [1] {s} {-f param-file-path}  \n");
    }

    public GriddedRegion getGriddedRegion() {
        return this.bgGrid.getRegion();
    }

    public ArrayList<STEP_CombineForecastModels> getSTEP_AftershockForecastList() {
        return this.STEP_AftershockForecastList;
    }

    public ArrayList<PointEqkSource> getSourceList() {
        return this.sourceList;
    }

    public void calc_STEP(GregorianCalendar startTime, GregorianCalendar forecastTime) {
        this.readSTEP_AftershockForecastListFromFile();
        if (!this.isScheduledOperation() || startTime != null) {
            // empty if block
        }
        STEP_main.log("Starting STEP startTime=" + startTime);
        this.eventStartTime = null;
        if (startTime != null) {
            this.eventStartTime = startTime;
        } else if (!this.isScheduledOperation() && RegionDefaults.EVENT_START_TIME != null) {
            this.eventStartTime = STEP_main.getCurrentGregorianTime();
            this.eventStartTime.setTimeInMillis(RegionDefaults.EVENT_START_TIME.getTimeInMillis());
        }
        this.currentTime = forecastTime == null ? (RegionDefaults.startForecastAtCurrentTime ? STEP_main.getCurrentGregorianTime() : RegionDefaults.forecastStartTime) : forecastTime;
        STEP_main.log("eventStartTime " + (this.eventStartTime != null ? RegionDefaults.dateformater.format(this.eventStartTime.getTime()) : "null"));
        STEP_main.log("currentTime " + RegionDefaults.dateformater.format(this.currentTime.getTime()));
        ObsEqkRupList newObsEqkRuptureList = this.loadNewEvents();
        if (newObsEqkRuptureList == null) {
            return;
        }
        ArrayList<HypoMagFreqDistAtLoc> hypList = this.loadBgGrid();
        this.processAfterShocks(this.currentTime, newObsEqkRuptureList);
        this.checkTypeIIAftershockZones();
        this.processForcasts(hypList);
        this.saveRatesFile(this.bgGrid);
        if (RegionDefaults.useCoulomb) {
            ApplyCoulombFilter cf_filter = new ApplyCoulombFilter();
            cf_filter.applyFilter(this.bgGrid, this.updateModel, this.STEP_AftershockForecastList);
        }
        this.createStepSources(hypList);
        if (RegionDefaults.SAVE_FORECAST_TIME) {
            this.saveForecastTime();
        }
    }

    private void saveForecastTime() {
        try {
            File file = new File(RegionDefaults.forecastStartTimeFile);
            if (file.exists()) {
                file.delete();
            }
            FileWriter forecastTimeFileWriter = new FileWriter(RegionDefaults.forecastStartTimeFile);
            forecastTimeFileWriter.write(RegionDefaults.dateformater.format(this.currentTime.getTime()));
            forecastTimeFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ObsEqkRupList loadNewEvents() {
        ObsEqkRupList newObsEqkRuptureList = null;
        if (RegionDefaults.EVENT_DATA_SOURCE == 1) {
            newObsEqkRuptureList = this.loadGeoNetEvents(this.eventStartTime, this.currentTime);
        } else if (RegionDefaults.EVENT_DATA_SOURCE == 0 || RegionDefaults.EVENT_DATA_SOURCE == 2 || RegionDefaults.EVENT_DATA_SOURCE == 3) {
            newObsEqkRuptureList = this.loadEventsFromFile(this.eventStartTime, this.currentTime, RegionDefaults.EVENT_DATA_SOURCE);
        } else {
            logger.error((Object)"please specify quake data source!!");
        }
        return newObsEqkRuptureList;
    }

    public ObsEqkRupList loadGeoNetEvents(Calendar start, Calendar end) {
        QuakeMLClient quakemlClient = new QuakeMLClient();
        return quakemlClient.retrieveEvents(start, end);
    }

    private void setTestTime(GregorianCalendar startTime) {
        if (startTime == null) {
            logger.error((Object)"setTestTime, event startTime not specified");
            System.exit(1);
        }
        int numRun = 3;
        this.currentTime.setTimeInMillis(startTime.getTimeInMillis() + (long)(numRun * 24 * 60 * 60) * 1000L);
        if (numRun < 1000) {
            RegionDefaults.outputAftershockRatePath = RegionDefaults.OUTPUT_DIR + "/TimeDepRates" + numRun + "d.txt";
        }
    }

    public void checkBgGrid() {
        LocationList bgLocList = this.bgGrid.getRegion().getNodeList();
        int bgRegionSize = bgLocList.size();
        for (int k = 0; k < bgRegionSize; ++k) {
            Location bgLoc = bgLocList.getLocationAt(k);
            HypoMagFreqDistAtLoc bgDistAtLoc = this.bgGrid.getHypoMagFreqDistAtLoc(k);
            double bgSumOver5 = bgDistAtLoc.getFirstMagFreqDist().getCumRate(RegionDefaults.minCompareMag);
            STEP_main.log(">>>>>>bgLoc=" + bgLoc + " bgSumOver5=" + bgSumOver5);
        }
    }

    public void checkTypeIIAftershockZones() {
        int numMainshocks = this.STEP_AftershockForecastList.size();
        ArrayList<STEP_CombineForecastModels> allSausageModels = new ArrayList<STEP_CombineForecastModels>();
        for (int msLoop = 0; msLoop < numMainshocks; ++msLoop) {
            STEP_CombineForecastModels model = this.STEP_AftershockForecastList.get(msLoop);
            model.setGridIsUpdated(false);
            if (model.isUseSausageRegion() || !model.updateAftershockZone()) continue;
            ObsEqkRupList newAfterShocks = new ObsEqkRupList();
            for (int index = 0; index < model.getAfterShocks().size(); ++index) {
                ObsEqkRupture shock = model.getAfterShocks().getObsEqkRuptureAt(index);
                if (!IsAftershockToMainshock_Calc.calc_IsAftershockToMainshock(model, shock)) continue;
                newAfterShocks.addObsEqkEvent(shock);
            }
            STEP_main.log("1 reprocessAftershockZone existing model.getAfterShocks(). " + model.getAfterShocks().size());
            model.getAfterShocks().clear();
            model.setAfterShocks(newAfterShocks);
            STEP_main.log("2 reprocessAftershockZone after model.getAfterShocks() " + model.getAfterShocks().size());
            allSausageModels.add(model);
        }
        for (STEP_CombineForecastModels sausageModel : allSausageModels) {
            STEP_main.log("1  existing aftershocks " + sausageModel.getAfterShocks().size());
            numMainshocks = this.STEP_AftershockForecastList.size();
            STEP_main.log("-- numMainshocks " + numMainshocks);
            int numNew = 0;
            for (int msLoop = 0; msLoop < numMainshocks; ++msLoop) {
                STEP_CombineForecastModels mainModel = this.STEP_AftershockForecastList.get(msLoop);
                ObsEqkRupture shock = mainModel.getMainShock();
                if (this.isObsEqkRupEventEqual(shock, sausageModel.getMainShock()) || sausageModel.getAfterShocks().getIndex(shock) >= 0 || !IsAftershockToMainshock_Calc.calc_IsAftershockToMainshock(sausageModel, shock)) continue;
                sausageModel.addToAftershockList(shock);
                for (int index = 0; index < mainModel.getAfterShocks().size(); ++index) {
                    ObsEqkRupture afterShock = mainModel.getAfterShocks().getObsEqkRuptureAt(index);
                    if (this.recheckAftershocks4sausageModel) {
                        if (!IsAftershockToMainshock_Calc.calc_IsAftershockToMainshock(sausageModel, afterShock)) continue;
                        sausageModel.addToAftershockList(afterShock);
                        continue;
                    }
                    sausageModel.addToAftershockList(afterShock);
                }
                mainModel.set_isStatic(true);
                ++numNew;
            }
            STEP_main.log("2 new added to sausage zone " + numNew + " new aftershocks " + sausageModel.getAfterShocks().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processForcasts(ArrayList<HypoMagFreqDistAtLoc> hypList) {
        int numAftershockModels = this.STEP_AftershockForecastList.size();
        STEP_main.log("processForcasts0 numAftershockModels  " + numAftershockModels);
        BackGroundRatesGrid backGroundRatesGrid = this.bgGrid;
        synchronized (backGroundRatesGrid) {
            for (int modelLoop = 0; modelLoop < numAftershockModels; ++modelLoop) {
                STEP_CombineForecastModels forecastModel = this.STEP_AftershockForecastList.get(modelLoop);
                if (forecastModel.getMainShock().getMag() < 7.0) {
                    // empty if block
                }
                forecastModel.set_UsedInForecast(false);
                this.updateModel = new UpdateSTEP_Forecast(forecastModel);
                this.updateModel.updateAIC_CombinedModelForecast();
                LocationList bgLocList = this.bgGrid.getRegion().getNodeList();
                int bgRegionSize = bgLocList.size();
                LocationList aftershockZoneList = forecastModel.getAfterShockZone().getNodeList();
                int asZoneSize = aftershockZoneList.size();
                double t_seqSumOver4 = 0.0;
                if (forecastModel.getMainShock().getMag() > 6.0) {
                    for (int as = 0; as < asZoneSize; ++as) {
                        Location loc = aftershockZoneList.getLocationAt(as);
                        HypoMagFreqDistAtLoc t_seqDistAtLoc = forecastModel.getHypoMagFreqDistAtLoc(as);
                        if (t_seqDistAtLoc == null) continue;
                        t_seqSumOver4 += t_seqDistAtLoc.getFirstMagFreqDist().getCumRate(0);
                    }
                    STEP_main.log("Total Forecast " + t_seqSumOver4);
                }
                for (int k = 0; k < bgRegionSize; ++k) {
                    Location bgLoc = bgLocList.getLocationAt(k);
                    for (int g = 0; g < asZoneSize; ++g) {
                        Location seqLoc = aftershockZoneList.getLocationAt(g);
                        if (seqLoc == null || !this.bgGrid.checkLocaionEquals(bgLoc, seqLoc, RegionDefaults.gridPrecision)) continue;
                        HypoMagFreqDistAtLoc seqDistAtLoc = forecastModel.getHypoMagFreqDistAtLoc(g);
                        HypoMagFreqDistAtLoc bgDistAtLoc = this.bgGrid.getHypoMagFreqDistAtLoc(k);
                        double bgSumOver5 = bgDistAtLoc.getFirstMagFreqDist().getCumRate(RegionDefaults.minCompareMag);
                        double seqSumOver5 = seqDistAtLoc.getFirstMagFreqDist().getCumRate(RegionDefaults.minCompareMag);
                        if (!(seqSumOver5 > bgSumOver5)) continue;
                        HypoMagFreqDistAtLoc hypoMagDistAtLoc = hypList.get(k);
                        Location loc = hypoMagDistAtLoc.getLocation();
                        hypList.set(k, new HypoMagFreqDistAtLoc(seqDistAtLoc.getFirstMagFreqDist(), loc));
                        this.bgGrid.setMagFreqDistAtLoc(seqDistAtLoc.getFirstMagFreqDist(), k);
                        this.bgGrid.setSeqIndAtNode(k, modelLoop);
                        forecastModel.set_UsedInForecast(true);
                    }
                }
                if (!forecastModel.get_UsedInForecast()) continue;
            }
        }
        double total_combined = 0.0;
        for (int gg = 0; gg < this.bgGrid.getNumHypoLocs(); ++gg) {
            HypoMagFreqDistAtLoc tcom_SeqDistLoc = this.bgGrid.getHypoMagFreqDistAtLoc(gg);
            if (tcom_SeqDistLoc == null) continue;
            total_combined += tcom_SeqDistLoc.getFirstMagFreqDist().getCumRate(0);
        }
        STEP_main.log("Total Combine Forecast = " + total_combined);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processAfterShocks(GregorianCalendar currtTime, ObsEqkRupList newObsEqkRuptureList) {
        STEP_CombineForecastModels foundMsModel = null;
        ListIterator newIt = newObsEqkRuptureList.listIterator();
        STEP_main.log("new events size " + newObsEqkRuptureList.size());
        boolean isAftershock = false;
        int numMainshocks = this.STEP_AftershockForecastList.size();
        STEP_main.log("start numMainshocks  " + numMainshocks);
        double maxMag = 0.0;
        ArrayList<STEP_CombineForecastModels> arrayList = this.STEP_AftershockForecastList;
        synchronized (arrayList) {
            int numBigEvent = 0;
            int numSameEvent = 0;
            block3: while (newIt.hasNext()) {
                ObsEqkRupture newEvent = (ObsEqkRupture)newIt.next();
                double newMag = newEvent.getMag();
                if (!this.bgGrid.getRegion().contains(newEvent.getHypocenterLocation())) continue;
                isAftershock = false;
                numMainshocks = this.STEP_AftershockForecastList.size();
                int maxMagInd = -1;
                maxMag = 0.0;
                for (int msLoop = 0; msLoop < numMainshocks; ++msLoop) {
                    STEP_CombineForecastModels mainshockModel = this.STEP_AftershockForecastList.get(msLoop);
                    ObsEqkRupture mainshock = mainshockModel.getMainShock();
                    if (this.isObsEqkRupEventEqual(mainshock, newEvent)) {
                        ++numSameEvent;
                        continue block3;
                    }
                    double msMag = mainshock.getMag();
                    mainshockModel.updateCurrentTime(currtTime);
                    if (!IsAftershockToMainshock_Calc.calc_IsAftershockToMainshock(mainshockModel, newEvent)) continue;
                    if (newMag >= msMag) {
                        mainshockModel.set_isStatic(true);
                    }
                    if (!(msMag > maxMag)) continue;
                    if (maxMagInd > -1) {
                        STEP_CombineForecastModels staticModel = this.STEP_AftershockForecastList.get(maxMagInd);
                        staticModel.set_isStatic(true);
                    }
                    maxMagInd = msLoop;
                    maxMag = msMag;
                }
                if (maxMagInd > -1) {
                    foundMsModel = this.STEP_AftershockForecastList.get(maxMagInd);
                    foundMsModel.addToAftershockList(newEvent);
                    isAftershock = true;
                }
                if (!(newMag >= RegionDefaults.minMagForMainshock)) continue;
                ++numBigEvent;
                STEP_CombineForecastModels newForecastMod = new STEP_CombineForecastModels(newEvent, this.bgGrid, currtTime);
                if (isAftershock) {
                    newForecastMod.set_isPrimary(false);
                }
                if (RegionDefaults.hasExternalFaultModel && newForecastMod.getMainShock().getMag() >= RegionDefaults.minCoulombMS_Mag) {
                    newForecastMod.setHasExternalFaultModel(RegionDefaults.hasExternalFaultModel);
                }
                this.STEP_AftershockForecastList.add(newForecastMod);
                ++numMainshocks;
            }
            numMainshocks = this.STEP_AftershockForecastList.size();
            STEP_main.log("end numMainshocks  " + numMainshocks);
        }
        return numMainshocks;
    }

    public ArrayList<HypoMagFreqDistAtLoc> loadBgGrid() {
        this.bgGrid = new BackGroundRatesGrid(this.bgRatesFilePath);
        return this.initStepHypoMagFreqDistForBGGrid(this.bgGrid);
    }

    public static GregorianCalendar getCurrentGregorianTime() {
        GregorianCalendar curTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        curTime.set(14, 0);
        return curTime;
    }

    public boolean isScheduledOperation() {
        return this.scheduledOperation;
    }

    public void setScheduledOperation(boolean scheduledOperation) {
        this.scheduledOperation = scheduledOperation;
    }

    public ObsEqkRupList loadEventsFromFile(GregorianCalendar start, GregorianCalendar end, int format) {
        CubeToObsEqkRupture getNewEvents = null;
        try {
            logger.info((Object)("loadEventsFromFile:  " + new File(this.eventsFilePath).getName()));
            if (RegionDefaults.EVENT_DATA_SOURCE == 0) {
                getNewEvents = new CubeToObsEqkRupture(this.eventsFilePath, start, end);
            } else if (RegionDefaults.EVENT_DATA_SOURCE == 2) {
                getNewEvents = new CubeToObsEqkRuptureChinaFormat(this.eventsFilePath, start, end);
            } else if (RegionDefaults.EVENT_DATA_SOURCE == 3) {
                getNewEvents = new CubeToObsEqkRuptureCsepFormat(this.eventsFilePath, start, end);
            }
            logger.info((Object)("getNewEvents  " + getNewEvents.getAllObsEqkRupEvents().size()));
            return getNewEvents.getAllObsEqkRupEvents();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private void saveRatesFile(ArrayList<PointEqkSource> sourcelist, String outputFile) {
        File existingFile = new File(outputFile);
        if (this.isScheduledOperation() && existingFile.exists()) {
            this.backupFile(existingFile, this.lastCurrTime);
        }
        int size = sourcelist.size();
        FileWriter fw = null;
        STEP_main.log("saveRatesFile " + existingFile.getAbsolutePath());
        try {
            fw = new FileWriter(outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        STEP_main.log("NumSources = " + size);
        for (PointEqkSource source : sourcelist) {
            double locRatesSum = 0.0;
            Location loc = source.getLocation();
            int numRuptures = source.getNumRuptures();
            for (int j = 0; j < numRuptures; ++j) {
                ProbEqkRupture rupture = source.getRupture(j);
                double prob = rupture.getProbability();
                double rate = -Math.log(1.0 - prob);
                locRatesSum += rate;
            }
            try {
                fw.write(this.locFormat.format(loc.getLatitude()) + "  " + this.locFormat.format(loc.getLongitude()) + "  " + locRatesSum + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void backupFile(File existingFile, GregorianCalendar fileTime) {
        SimpleDateFormat timeformater = new SimpleDateFormat("yyyy_MM_dd'T'HH_mm_ss");
        String filename = existingFile.getName();
        filename = filename.replace(".", timeformater.format(fileTime.getTime()) + ".");
        File desFile = new File(existingFile.getParentFile().getAbsolutePath() + "/" + filename);
        try {
            int len;
            FileInputStream in = new FileInputStream(existingFile);
            FileOutputStream out = new FileOutputStream(desFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            logger.info((Object)("backup File " + desFile.getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStepSources(ArrayList<HypoMagFreqDistAtLoc> hypoMagDist) {
        System.out.println("Creating STEP sources");
        if (this.sourceList == null) {
            this.sourceList = new ArrayList();
        } else {
            this.sourceList.clear();
        }
        int size = hypoMagDist.size();
        STEP_main.log("NumSources in hypList = " + size);
        int nullSource = 0;
        int zeroSource = 0;
        ArrayList<PointEqkSource> arrayList = this.sourceList;
        synchronized (arrayList) {
            for (HypoMagFreqDistAtLoc hypoLocMagDist : hypoMagDist) {
                if (hypoLocMagDist == null) {
                    ++nullSource;
                    continue;
                }
                Location loc = hypoLocMagDist.getLocation();
                IncrementalMagFreqDist magDist = hypoLocMagDist.getFirstMagFreqDist();
                double rate = magDist.getY(0);
                if (rate != 0.0) {
                    PointEqkSource source = new PointEqkSource(loc, magDist, RegionDefaults.forecastLengthDays, 100.0, 90.0, RegionDefaults.minForecastMag);
                    this.sourceList.add(source);
                    continue;
                }
                ++zeroSource;
            }
        }
    }

    private ArrayList<HypoMagFreqDistAtLoc> initStepHypoMagFreqDistForBGGrid(BackGroundRatesGrid bgGrid) {
        ArrayList hypForecastList = bgGrid.getHypoMagFreqDist();
        ArrayList<HypoMagFreqDistAtLoc> stepHypForecastList = new ArrayList<HypoMagFreqDistAtLoc>();
        int size = hypForecastList.size();
        for (HypoMagFreqDistAtLoc hypForcast : hypForecastList) {
            HypoMagFreqDistAtLoc newHypoMagFreqDistAtLoc = null;
            IncrementalMagFreqDist hypForecastMagDist = null;
            if (hypForcast != null) {
                Location loc = hypForcast.getLocation();
                IncrementalMagFreqDist magDist = hypForcast.getFirstMagFreqDist();
                hypForecastMagDist = new IncrementalMagFreqDist(magDist.getMinX(), magDist.getNum(), magDist.getDelta());
                for (int j = 0; j < hypForecastMagDist.getNum(); ++j) {
                    hypForecastMagDist.set(j, 0.0);
                }
                newHypoMagFreqDistAtLoc = new HypoMagFreqDistAtLoc(hypForecastMagDist, loc);
            }
            stepHypForecastList.add(newHypoMagFreqDistAtLoc);
        }
        return stepHypForecastList;
    }

    private void saveRatesFile(BackGroundRatesGrid bggrid) {
        try {
            File existingFile = new File(RegionDefaults.outputAftershockRatePath);
            if (this.isScheduledOperation() && existingFile.exists()) {
                this.lastCurrTime = new GregorianCalendar();
                this.lastCurrTime.setTimeInMillis(existingFile.lastModified());
                this.backupFile(existingFile, this.lastCurrTime);
            }
            FileWriter fr = new FileWriter(RegionDefaults.outputAftershockRatePath);
            LocationList bgLocList = bggrid.getRegion().getNodeList();
            int bgRegionSize = bgLocList.size();
            STEP_main.log("saveRatesFile: " + new File(RegionDefaults.outputAftershockRatePath).getAbsolutePath());
            for (int k = 0; k < bgRegionSize; ++k) {
                Location bgLoc = bgLocList.getLocationAt(k);
                HypoMagFreqDistAtLoc bgDistAtLoc = bggrid.getHypoMagFreqDistAtLoc(k);
                if (bgDistAtLoc == null) continue;
                int numForecastMags = 1 + (int)((RegionDefaults.maxForecastMag - RegionDefaults.minForecastMag) / RegionDefaults.deltaForecastMag);
                for (int index = 0; index < numForecastMags; ++index) {
                    double mag = RegionDefaults.minForecastMag + (double)index * RegionDefaults.deltaForecastMag;
                    double rate = bgDistAtLoc.getFirstMagFreqDist().getIncrRate(mag);
                    if (rate == 0.0) {
                        rate = 1.0E-11;
                    }
                    fr.write(this.locFormat.format(bgLoc.getLongitude() - RegionDefaults.gridSpacing / 2.0) + "    " + this.locFormat.format(bgLoc.getLongitude() + RegionDefaults.gridSpacing / 2.0) + "    " + this.locFormat.format(bgLoc.getLatitude() - RegionDefaults.gridSpacing / 2.0) + "    " + this.locFormat.format(bgLoc.getLatitude() + RegionDefaults.gridSpacing / 2.0) + "    " + RegionDefaults.MIN_Z + "    " + RegionDefaults.MAX_Z + "    " + this.magFormat.format(mag - RegionDefaults.deltaForecastMag / 2.0) + "    " + this.magFormat.format(mag + RegionDefaults.deltaForecastMag / 2.0) + "    " + rate + "     1\n");
                }
            }
            fr.close();
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
    }

    public GregorianCalendar getLastCurrTime() {
        return this.lastCurrTime;
    }

    public synchronized void readSTEP_AftershockForecastListFromFile() {
        this.STEP_AftershockForecastList = null;
        this.lastCurrTime = null;
        try {
            File sourceFile = new File(RegionDefaults.STEP_AftershockObjectFile);
            STEP_main.log("readSTEP_AftershockForecastListFromFile: " + sourceFile.getAbsolutePath());
            if (sourceFile.exists()) {
                this.STEP_AftershockForecastList = (ArrayList)FileUtils.loadObject(RegionDefaults.STEP_AftershockObjectFile);
                if (this.STEP_AftershockForecastList.size() > 0) {
                    STEP_CombineForecastModels model0 = this.STEP_AftershockForecastList.get(0);
                    this.lastCurrTime = model0.getCurrentTime();
                    logger.info((Object)("lastCurrTime " + localDateformater.format(this.lastCurrTime.getTime())));
                }
            } else {
                logger.error((Object)("error STEP_AftershockObjectFile not exist!!" + sourceFile.getAbsolutePath()));
            }
            if (this.STEP_AftershockForecastList == null) {
                this.STEP_AftershockForecastList = new ArrayList();
            }
        }
        catch (Exception ex) {
            logger.error((Object)("readSTEP_AftershockForecastListFromFile error " + ex));
            this.STEP_AftershockForecastList = new ArrayList();
        }
        logger.info((Object)("readSTEP_AftershockForecastListFromFile size " + this.STEP_AftershockForecastList.size()));
    }

    public String getEventsFilePath() {
        return this.eventsFilePath;
    }

    public void setEventsFilePath(String eventsFilePath) {
        this.eventsFilePath = eventsFilePath;
    }

    public String getBgRatesFilePath() {
        return this.bgRatesFilePath;
    }

    public void setBgRatesFilePath(String bgRatesFilePath) {
        this.bgRatesFilePath = bgRatesFilePath;
    }

    public BackGroundRatesGrid getBgGrid() {
        return this.bgGrid;
    }

    public boolean isObsEqkRupEventEqual(ObsEqkRupture obsRupEvent0, ObsEqkRupture obsRupEvent) {
        obsRupEvent0.equalsObsEqkRupEvent(obsRupEvent);
        if (!obsRupEvent0.getEventId().equals(obsRupEvent.getEventId()) || obsRupEvent0.getOriginTime().getTimeInMillis() != obsRupEvent.getOriginTime().getTimeInMillis() || obsRupEvent0.getEventVersion() != obsRupEvent.getEventVersion() || !obsRupEvent0.getMagType().equals(obsRupEvent.getMagType()) || obsRupEvent0.getMag() != obsRupEvent.getMag()) {
            if (obsRupEvent0.getEventId().equals(obsRupEvent.getEventId())) {
                // empty if block
            }
            return false;
        }
        return true;
    }

    public GregorianCalendar getCurrentTime() {
        return this.currentTime;
    }

    public static void log(String string) {
        logger.info((Object)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveModels() {
        if (this.isScheduledOperation()) {
            PurgeMainshockList.removeModels(this.STEP_AftershockForecastList);
        }
        logger.info((Object)("save STEP_AFTERSHOCK_OBJECT_FILE " + RegionDefaults.STEP_AftershockObjectFile));
        ArrayList<STEP_CombineForecastModels> arrayList = this.getSTEP_AftershockForecastList();
        synchronized (arrayList) {
            FileUtils.saveObjectInFile(RegionDefaults.STEP_AftershockObjectFile, this.getSTEP_AftershockForecastList());
        }
    }
}

