#!/bin/tcsh

# batch_ANSS1985_30min.tcsh:
#
# Run daily Dispatcher for Califonia thirty-minutes forecast models generation
# and evaluation
# (all groups are using the same input ANSS catalog with start date of 1985-01-01
#  and minimum magnitude threshold of 3.0)
#

source ~/.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`

# Pad time values with zero's
set hour=`date '+%H'`
set min=`date '+%M'`
set sec=`date '+%S'`

# Capture all output produced by Dispatcher into the daily log file
set logdir=$CSEP/dispatcher/logs/"$year"_"$month"
mkdir -p "$logdir"

set logfile="$logdir"/batchDailyANSS1985_"$year-$month-$day-$hour$min$sec"


# Invoke BatchProcessing for "today" (with 31 day delay for the testing date):
nohup python $CENTERCODE/src/generic/BatchProcessing.py \
--year="$year" --month="$month" --day="$day" --hour="0:23" --min="0:30:30" --second="0" \
--configFile=/usr/local/csep/cronjobs/batch_ANSS1985_30min.init.xml \
--logFile="$logfile" >& "$logfile" &
