#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

# quakepy/utils/pov2cpt.py
# $Id: pov2cpt.py 240 2009-10-19 21:16:09Z danijel $
#
# The QuakePy package
# http://www.quakepy.org
#

############################################################################
#    Copyright (C) 2007 by Danijel Schorlemmer                             #
#    ds@usc.edu                                                            #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

"""
The QuakePy package
http://www.quakepy.org

pov2cpt.py

convert PovRay-colorbars (exported from GIMP) to cpt-files for GMT
"""

__version__  = '$Id: pov2cpt.py 240 2009-10-19 21:16:09Z danijel $'
__revision__ = '$Revision: 240 $'
__author__   = "Danijel Schorlemmer <ds@usc.edu>"
__license__  = "GPL"

import sys
import getopt
from math import floor
import re
import colorsys
import random


def main():
  # Set defaults
  #fMin = 0
  #fMax = 1
  #bBackgroundColor = False
  #vBackgroundColor = [0, 0, 0]
  #bDiscrete = False
  #bExtent = False
  #bFlip = False
  #bForegroundColor = False
  #vForegroundColor = [0, 0, 0]
  #bInteger = False
  #bLogScale = False
  #bValuesAlreadyLog = False
  #bPale = False
  bOutput2Standard = True
  #vNaNColor = [0, 0, 0]
  #bNaNColor = False
  #sCptFilename = ''
  # Read commandline arguments
  sCmdParams = sys.argv[1:]
  opts, args = getopt.gnu_getopt(sCmdParams, 'a:b:B:d:efF:hilLn:o:p:', ['min=', 'max=', 'background=', 'discrete=', 'extend', 'flip', 'foreground=', 'help', 'integer', 'log', 'Log', 'nan=', 'output=', 'pale='])
  for option, parameter in opts:
    #if option == '-a' or option == '--min':
      #fMin = float(parameter)
    #if option == '-b' or option == '--max':
      #fMax = float(parameter)
    #if option == '-B' or option == '--background':
      #bBackgroundColor = True
      #vRGB = re.split(r'/', parameter)
      #if vRGB:
        #vBackgroundColor[0] = float(vRGB[0])
        #vBackgroundColor[1] = float(vRGB[1])
        #vBackgroundColor[2] = float(vRGB[2])
    #if option == '-d' or option == '--discrete':
      #bDiscrete = True
      #fNumSteps = int(parameter)
    #if option == '-e' or option == '--extend':
      #bExtent = True
    #if option == '-f' or option == '--flip':
      #bFlip = True
    #if option == '-F' or option == '--foreground':
      #bForegroundColor = True
      #vRGB = re.split(r'/', parameter)
      #if vRGB:
        #vForegroundColor[0] = float(vRGB[0])
        #vForegroundColor[1] = float(vRGB[1])
        #vForegroundColor[2] = float(vRGB[2])
    #if option == '-i' or option == '--integer':
      #bInteger = True
    #if option == '-l' or option == '--log':
      #bLogScale = True
      #bValuesAlreadyLog = True
    #if option == '-L' or option == '--Log':
      #bLogScale = True
      #bValuesAlreadyLog = False
    #if option == '-n' or option == '--nan':
      #bNaNColor = True
      #vRGB = re.split(r'/', parameter)
      #if vRGB:
        #vNaNColor[0] = float(vRGB[0])
        #vNaNColor[1] = float(vRGB[1])
        #vNaNColor[2] = float(vRGB[2])
    if option == '-o' or option == '--output':
      bOutput2Standard = False
      sOutputFilename = parameter
    #if option == '-p' or option == '--pale':
      #if (float(parameter) > 1) or (float(parameter) < 0):
        #print 'ERROR: Value for pale colorbar must be in the range [0,1]'
        #sys.exit()
      #bPale = True
      #fPaleFactor = float(parameter)
    if option == '-h' or option == '--help':
      print 'Creates the global high-res forecast template'
      print 'Version 1.0 [21.11.2013]'
      print 'Usage: create.forecast.template.global.py [OPTION]'
      #print '   -a, --min=<value>          minimum value on colorbar (default = 0)'
      #print '   -b, --max=<value>          maximum value on colorbar (default = 1)'
      #print '   -B, --background=<r/g/b>   defines the B-entry at the end of the cpt-file'
      #print '   -d, --discrete=<value>     discrete colors with <value> steps (default continuous)'
      #print '   -e, --extent               extent colorbar (F/B values)'
      #print '   -f, --flip                 flip colorbar'
      #print '   -F, --foreground=<r/g/b>   defines the F-entry at the end of the cpt-file (overrides -e)'
      #print '   -h, --help                 print this information'
      #print '   -i, --integer              output color values as integer'
      #print '   -l, --log                  create a log10 scale from min- to max-value'
      #print '   -L, --Log                  create a log10 scale from log10(min) to log10(max)'
      #print '   -n, --nan=<r/g/b>          defines the N-entry at the end of the cpt-file (overrides -e)'
      print '   -o, --output=<filename>    output to file instead of stdout'
      #print '   -p, --pale=<value>         create pale colorbar (multiply saturation by value)'
      sys.exit()
  #sPovRayFilename = args[0]
  #mColormap = ReadPovRay(sPovRayFilename)
  #if bPale:
    #mColormap = CreatePale(mColormap, fPaleFactor)
  #if bFlip:
    #mColormap = Flip(mColormap)
  #if (bLogScale) and (bValuesAlreadyLog == False):
    #fMin = log10(fMin)
    #fMax = log10(fMax)
  #mCpt = Scale(mColormap, fMin, fMax)
  #if bDiscrete:
    #mCpt = Discretize(mCpt, fMin, fMax, fNumSteps)
  #if bLogScale:
    #mCpt = RestoreZValues(mCpt)
  #mCpt = PrepareForWriting(mCpt, bDiscrete)
  #WriteCpt(bOutput2Standard, sCptFilename, mCpt, bExtent, bForegroundColor, vForegroundColor, bBackgroundColor, vBackgroundColor, bNaNColor, vNaNColor, bInteger)
  if bOutput2Standard:
    ftOutput = sys.stdout
  else:
    ftOutput = file(sOutputFilename, "w")
#  nLen = len(mCpt[0])
  fMinDepth = 0
  fMaxDepth = 70
  
  ftOutput.write('<?xml version="1.0"?>' + '\n')
  ftOutput.write('<CSEPForecast xmlns="http://www.scec.org/xml-ns/csep/forecast/1.1">' + '\n')
  ftOutput.write('  <forecastData publicID="smi://org.scec/csep/forecast/1">' + '\n')
  ftOutput.write('    <modelName>Put your model name here</modelName>' + '\n')
  ftOutput.write('    <!-- version is a free-form string, but mandatory -->' + '\n')
  ftOutput.write('    <version>Put your version number here</version>' + '\n')
  ftOutput.write('    <author>Put your name here</author>' + '\n')
  ftOutput.write('    <!-- authorURI is optional -->' + '\n')
  ftOutput.write('    <authorURI>smi://org.scec/persons/familyname_firstname</authorURI>' + '\n')
  ftOutput.write('    <!-- issueDate has to be given in UTC -->' + '\n')
  ftOutput.write('    <issueDate>2007-03-15T16:00:00Z</issueDate>' + '\n')
  ftOutput.write('    <!-- forecastStartDate has to be given in UTC -->' + '\n')
  ftOutput.write('    <forecastStartDate>2007-03-16T16:00:00Z</forecastStartDate>' + '\n')
  ftOutput.write('    <!-- forecast duration in days -->' + '\n')
  ftOutput.write('    <forecastDuration>365</forecastDuration>' + '\n')
  ftOutput.write('    <cellDimension lonRange="0.1" latRange="0.1"/>' + '\n')
  ftOutput.write('    <magnitudeBinDimension>0.1</magnitudeBinDimension>' + '\n')
  ftOutput.write('    <magnitudeMinValue>3.95</magnitudeMinValue>' + '\n')
  ftOutput.write('    <lastMagBinOpen>1</lastMagBinOpen>\n')
  ftOutput.write('    <depthLayer min="0" max="30">' + '\n')
  for fLon in ext_range(-179.95, 179.95, 0.1):
    for fLat in ext_range(-89.95, 89.95, 0.1):
      sLine = '      <cell lon="' + str(fLon) + '" lat="' + str(fLat) + '">'
      for fMag in ext_range(1, 30, 1):
        #sLine = sLine + str(random.random()) + ' '
        sLine = sLine + str(0.0) + ' '
      #sLine = sLine + str(random.random()) + '</cell>' + '\n'
      sLine = sLine + str(0.0) + '</cell>' + '\n'
      ftOutput.write(sLine)
  ftOutput.write('    </depthLayer>' + '\n')
  ftOutput.write('  </forecastData>' + '\n')
  ftOutput.write('</CSEPForecast>' + '\n')

    
#def WriteCpt(bOutput2Standard, sFilename, mCpt, bExtent, bForegroundColor, vForegroundColor, bBackgroundColor, vBackgroundColor, bNaNColor, vNaNColor, bInteger):


# ---
def ext_range(start, end, step):
    while start <= end:
        yield start
        start += step

main()
