"""
Module EEPAS0FOneYearModel
"""

__version__ = "$Revision$"
__revision__ = "$Id$"

import os

import CSEPFile
from EEPASOneYearModel import EEPASOneYearModel
from Forecast import Forecast
from CSEPStorage import CSEPStorage
from CatalogDataSource import CatalogDataSource


#--------------------------------------------------------------------------------
#
# EEPAS-0F forecast model.
#
# This class is designed to invoke three-months PPE and EEPAS forecast models. 
# It uses 'eepas_0f.par' configuration for the run. It has model weights
# disabled.
#
class EEPAS0FOneYearModel (EEPASOneYearModel):

    # Static data of the class
    
    # Keyword identifying the type of the forecast
    Type = EEPASOneYearModel.Type + "-0F"
    
    
    #--------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    #        args - Optional arguments for the model. Default is None.
    # 
    def __init__ (self, dir_path, args = None):
        """ Initialization for EEPAS0FModel class"""
        
        EEPASOneYearModel.__init__(self, 
                                   dir_path, 
                                   args, 
                                   "nzeepas_0f.par")
        

    #----------------------------------------------------------------------------
    #
    # Return keyword identifying the model.
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    def type (self):
        """ Returns keyword identifying the forecast model type."""
        
        return EEPAS0FOneYearModel.Type


        
