"""
Module HelmstetterWernerModel
"""

__version__ = "$Revision$"
__revision__ = "$Id$"

import os

import Environment, CSEPFile, CSEP
from Forecast import Forecast
from DataSourceFactory import DataSourceFactory
from CSEPInputParams import CSEPInputParams
from GeoNetNZDataSource import GeoNetNZDataSource


#--------------------------------------------------------------------------------
#
# HelmstetterWernerModel forecast model for New Zealand.
#
# This class is a helper to invoke any of Agnes Helmstetter/Max Werner forecasts
# models.
#
class HelmstetterWernerModel (object):

    # Static data of the class

    # Center code path for the model
    _path = os.path.join(Forecast.CodePath, 
                         'NewZealand',
                         'src',
                         'HelmstetterWernerModels')

    __parametersDir = 'parameters'
    __commonDir = 'commonInputData'
    
    
    #--------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        args - Optional arguments for the model. Default is None.
    # 
    def __init__ (self, args = None):
        """ Initialization for HelmstetterWernerModel class"""
        
        pass
    
    
    #--------------------------------------------------------------------
    #
    # Write input parameter file for the model in following format:
    # $ cat csep-input-file-ETAST1.txt: 
    # forecastStartDate=2010-09-03T16:35:42Z
    # forecastEndDate=2010-09-04T16:35:42Z
    # InputCatalogFile=Canterbury_M2_1980_2012.txt
    # InputParameterFile=E_m3M4_T1_pl.par
    # OutputForecastFile=E_m3M4_T1_pl/E_m3M4_T1_pl_forecast_2010-09-03T16:35:42Z.xml
    # CommonInputDir=INPUT_COMMON/
    #        
    def writeFile (self, 
                   fhandle,
                   start_date,
                   end_date,
                   input_catalog,
                   result_forecast,
                   parameter_file):
        """ Format input parameter file for the model.
            Path to created input parameter file will be passed to the 
            model's executable."""

        # Input parameters include:
        line = "forecastStartDate=%sZ\n" \
               %start_date.strftime(CSEP.Time.ISO8601Format)
        fhandle.write(line)

        line = "forecastEndDate=%sZ\n" \
               %end_date.strftime(CSEP.Time.ISO8601Format)
        fhandle.write(line)
        
        line = "InputCatalogFile=%s\n" %input_catalog
        fhandle.write(line)

        line = "InputParameterFile=%s\n" %os.path.join(HelmstetterWernerModel._path,
                                                       HelmstetterWernerModel.__parametersDir,
                                                       parameter_file)
        fhandle.write(line)

        line = "OutputForecastFile=%s\n" %result_forecast
        fhandle.write(line)

        line = "CommonInputDir=%s%s\n" %(os.path.join(HelmstetterWernerModel._path,
                                                      HelmstetterWernerModel.__commonDir),
                                         os.sep) 
        fhandle.write(line)


    #---------------------------------------------------------------------------
    #
    # Return commands that should be used to capture version of external
    # software packages the model is dependent on. 
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    @staticmethod
    def externalSoftwareVersions ():
        """ Returns dictionary of command to determine external software 
            version and flag if output of that command is redirected to the
            stderr (True) or not (False) (java -version, for example)."""
        
        return {"gfortran --version" : False}

