"""
Module PPEDECLUSModel
"""

__version__ = "$Revision$"
__revision__ = "$Id$"


import os, datetime

import Environment, CSEPFile, CSEPLogging, CSEP
from Forecast import Forecast
from OneYearForecast import OneYearForecast
from EEPASOneYearModel import EEPASOneYearModel


#--------------------------------------------------------------------------------
#
# EEPAS-0F forecast model.
#
# This class is designed to invoke three-months PPE and EEPAS forecast model. 
# It prepares input catalog data, formats control file with model parameters,
# and invokes the model. It places forecast file under user specified directory.
#
class PPEDECLUSOneYearModel (EEPASOneYearModel):

    # Static data of the class
    
    # Keyword identifying the type of the forecast
    Type = "PPEDECLUS" + OneYearForecast.Type


    #----------------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    #        args - Optional arguments for the model. EEPAS models don't 
    #               require any configurable inputs by the CSEP system.
    #        param_file - Parameter file for a specific model configuration.
    #        use_weights - Flag if model shouuld use weights. Default is 0 (False).
    # 
    def __init__ (self, dir_path, args=None):
        """ Initialization for EEPASModel class"""
        
        weigths = 1
        EEPASOneYearModel.__init__(self, 
                                   dir_path,
                                   args,
                                   "nzeepas_0f.par",
                                   weigths)


    #----------------------------------------------------------------------------
    #
    # Return keyword identifying the model.
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    def type (self):
        """ Returns keyword identifying the forecast model type."""
        
        return self.Type


    def nFile (self):
        """ Return file identifier for whole forecast file"""
        
        return '26'


    def timeVariantForecastFile (self):
        """ Return filename for time-variant component of the forecast"""
         
        return None
    

    #----------------------------------------------------------------------------
    #
    # Writes grid information that are specific to the model configuration.
    #
    # Input:
    #        fhandle - Handle to the open control file used to invoke the model.
    #
    # Output:
    #        Handle to the control file.
    #        
    def writeGrids (self, fhandle):
        """ Writes grid information that are specific to the model configuration."""

        fhandle.write("PPEGRID\n")
        
        return fhandle


    def writeDeclusterFlag (self, fhandle):
        """ Writes decluster flag to parameter file if there are any."""

        fhandle.write("declus 1\n")
        return fhandle


    #----------------------------------------------------------------------------
    #
    # Returns name of the testing area polygon file that is specific to the 
    # model configuration.
    #
    # Input: None
    #
    # Output:
    #        Name of the file.
    #        
    def polygonFile (self):
        """ Returns name of the testing area polygon file that is specific to the 
            model configuration."""

        return 'nztestpoly.dat'


    #---------------------------------------------------------------------------
    #
    # Return commands that should be used to capture version of external
    # software packages the model is dependent on. 
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    @staticmethod
    def externalSoftwareVersions ():
        """ Returns dictionary of command to determine external software 
            version and flag if output of that command is redirected to the
            stderr (True) or not (False) (java -version, for example)."""
        

        return {} 

