"""
Module SUPOneYearModel
"""

__version__ = "$Revision$"
__revision__ = "$Id$"

import os

import CSEPFile
from EEPASOneYearModel import EEPASOneYearModel
from Forecast import Forecast
from OneYearForecast import OneYearForecast
from CSEPStorage import CSEPStorage
from CatalogDataSource import CatalogDataSource


#--------------------------------------------------------------------------------
#
# SUP (stationary uniform Poisson forecast model.
#
# This class is designed to invoke one-year SUP forecast model. 
# It uses 'eepas_0f.par' configuration for the run. It has model weights
# disabled.
#
class SUPOneYearModel (EEPASOneYearModel):

    # Static data of the class
    
    # Keyword identifying the type of the forecast
    Type = "SUP" + OneYearForecast.Type
    
    # No weights
    __weights = 0
    
    
    #--------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    #        args - Optional arguments for the model. Default is None.
    # 
    def __init__ (self, dir_path, args = None):
        """ Initialization for EEPAS0FModel class"""
        
        EEPASOneYearModel.__init__(self, 
                                   dir_path, 
                                   args, 
                                   "nzeepas_0f.par")
        

    #----------------------------------------------------------------------------
    #
    # Return keyword identifying the model.
    #
    # Input: None.
    #
    # Output:
    #           String identifying the type
    #
    def type (self):
        """ Returns keyword identifying the forecast model type."""
        
        return SUPOneYearModel.Type
    

    #----------------------------------------------------------------------------
    #
    # Writes grid information that are specific to the model configuration.
    #
    # Input:
    #        fhandle - Handle to the open control file used to invoke the model.
    #
    # Output:
    #        Handle to the control file.
    #        
    def writeGrids (self, fhandle):
        """ Writes grid information that are specific to the model configuration."""

        fhandle.write("SUPGRID\n")
        
        return fhandle


    def nFile (self):
        """ Return file identifier for whole forecast file"""
        
        return '26'

        
    def timeVariantForecastFile (self):
        """ Return filename for time-variant component of the forecast"""
         
        return None


    #---------------------------------------------------------------------------
    #
    # Write weight and likelihood directives if any are defined for the model
    #
    def writeWeightingLikelihood(self, fhandle):
    
        catalog_end_date = self.start_date
        
        fhandle.write("PERIOD\n")
        fhandle.write("1951, 01, 01, %s, %s, %s/ y1,m1,d1,y2,m2,d2\n" %(catalog_end_date.year,
                                                                        catalog_end_date.month,
                                                                        catalog_end_date.day))
        fhandle.write("WEIGHTS\n")
        fhandle.write("%s\n" %SUPOneYearModel.__weights)
        fhandle.write("COMPUTE WEIGHTS\n")
        fhandle.write("LIKELIHOODS\n")
