#!/bin/tcsh

# one_year_forecasts.tcsh:
#
# Evaluate one-month forecasts generated with "realtime" input catalog from GeoNet.
#

source /home/csep/DarfieldExperiment/realtimeTC/init.tcshrc

set year=`date '+%Y'`
# Don't pad integer values with zero's
set month=`date '+%_m'`
set day=`date '+%_d'`

# Pad time values with zero's
set hour=`date '+%H'`
set min=`date '+%M'`
set sec=`date '+%S'`
mkdir -p /home/csep/DarfieldExperiment/realtimeTC/logs
mkdir -p /home/csep/DarfieldExperiment/realtimeTC/batch/logs
mkdir -p /home/csep/DarfieldExperiment/realtimeTC/batch/runs

# Capture all output produced by Dispatcher into the daily log file
set logfile=/home/csep/DarfieldExperiment/realtimeTC/batch/logs/oneMonthForecastsEvaluation_"$year-$month-$day-$hour$min$sec"


# Invoke BatchProcessing for "today":
nohup python $CENTERCODE/src/generic/BatchProcessing.py --configFile=/home/csep/DarfieldExperiment/realtimeTC/batch/config/batch_one_month_evaluation.init.xml --logFile="$logfile" >& "$logfile" &
