"""
OneMonthForecast module
"""

__version__ = "$Revision$"
__revision__ = "$Id$"


import os

import Environment, Forecast, OneDayModelInputPostProcess


#-------------------------------------------------------------------------------------
#
# OneMonthForecast forecast model.
#
# This class is designed to invoke a one-month forecast model. It prepares 
# input catalog data, formats input file with model parameters, and invokes
# the model. It places forecast file under the user specified directory.
# This is a base class with virtual 'create()' method that should be 
# overloaded by children classes.
#
class OneMonthForecast (Forecast.Forecast):

    # Static data of the class 
    Type = "OneMonth"

    # Forecast template file to be used by the model - if the model populates
    # the template instead of using it's own one
    TemplateFile = os.path.join(Environment.Environment.Variable[Environment.CENTER_CODE_ENV],
                                "data", 
                                "templates", 
                                "csep-forecast-template-M4.xml")
    
    
    #--------------------------------------------------------------------
    #
    # Initialization.
    #
    # Input: 
    #        dir_path - Directory to store forecast file to.
    # 
    def __init__ (self, 
                  dir_path,
                  catalog_type = OneDayModelInputPostProcess.OneDayModelInputPostProcess.Type):
         """ Initialization for OneMonthForecast class"""
        
         Forecast.Forecast.__init__(self, dir_path, 
                                    OneMonthForecast.TemplateFile,
                                    catalog_type)
         

    #----------------------------------------------------------------------------
    #
    # Calculate end date for the forecast period. 
    #
    # Input: 
    #        start_date - Forecast period start date.
    # 
    # Output:
    #         None.
    # 
    def setPeriod (self, 
                   start_date,
                   num_years=0, 
                   num_months=1, 
                   num_days=None,
                   num_hours=None,
                   num_mins=None,
                   num_secs=None):
        """ Set start and end date for the forecast period."""

        Forecast.Forecast.setPeriod(self, 
                                    start_date, 
                                    num_years, 
                                    num_months, 
                                    num_days,
                                    num_hours,
                                    num_mins,
                                    num_secs)

