"""
Module NZTests
"""

__version__ = "$Revision$"
__revision__ = "$Id$"


import unittest


#--------------------------------------------------------------------------------
#
# NZTests
#
# This module is designed as an acceptance test suite for the New Zealand
# specific codes.

# It consists of:
#
# Catalog download
from NZCatalogRetrievalTest import CatalogRetrievalTest

# Catalog pre-processing - reformatting of the catalog data into the ZMAP format
from NZCatalogPreProcessingTest import CatalogPreProcessingTest

# Catalog post-processing for:
#    - shortterm forecasts evaluations (generate observations for the shortterm forecasts).
#    - shortterm forecasts models (generate input catalog for the shortterm
#     forecast generation).
from NZCatalogPostProcessingTest import CatalogPostProcessingTest


# Invoke the module
if __name__ == '__main__':
   
   from DataSourceFactory import DataSourceFactory
   from GeoNetNZDataSource import GeoNetNZDataSource
   from CSEPTestCase import CSEPTestCase
   import GeographicalRegions

   # Set NZ data source
   DataSourceFactory.composite().clear()
   DataSourceFactory().object(GeoNetNZDataSource.Type,
                              input_variables = CSEPTestCase.DataSourceArgs)
    
   GeographicalRegions.Region().set('NewZealand')

   
   # Invoke all tests
   unittest.main()
        
# end of main
